##PROJECT_GLOBAL_BEGIN
[Programs]
Count=1

[Misc Info]
Author=
Company=
Version=1.0
EditTime=6072
CyProVersion=3.0.8

[Protection]
Level=0
Password=
##PROJECT_GLOBAL_END

##PROGRAM_BEGIN_1
#PROJECT_OPTIONS_BEGIN
[Program]
Name=project_name

[VCP]
I2CPriority=5
SendSource=1
SendAlloc=1
ProtectWithPasswd=0
Password=
ScanOverrunStopsProgram=1
OutputRetentive=0
AutoStart=1
Com1Mode=1
Com1Baudrate=3
Com1Data=0
Com2Mode=1
Com2Baudrate=3
Com2Data=0
EthAbusEnable=1
EthModbusEnable=0
WANUrl=
PushEvent=0
PushUrl=
ModbusDelay=20
ModbusDeviceAddress=1
ModbusPLCDataModel=2
ModbusAddress=0
ModbusRegisterCount=1
ModbusCoilsArrayVar=
ModbusRegistersArrayVar=
PLCCoilVars=
PLCRegisterVars=
ModbusCoilAddresses=
ModbusRegisterAddresses=

[Misc Info]
MonitorHistorySpeed=10

[Hardware]
CPUUnit=10
VarAreaTyp0.7.0=0
VarAreaTyp0.7.1=0
VarAreaTyp0.7.2=0
VarAreaTyp0.7.3=0
VarAreaTyp0.7.4=0
VarAreaTyp0.7.5=0
Card1=60
Type1=0
NAD1=100
VarPrefix1=lc00_
Card2=60
Type2=0
NAD2=101
VarPrefix2=lc01_
Card3=60
Type3=0
NAD3=102
VarPrefix3=lc02_
Card4=60
Type4=0
NAD4=103
VarPrefix4=lc03_
Card5=60
Type5=0
NAD5=104
VarPrefix5=lc04_
Card6=60
Type6=0
NAD6=105
VarPrefix6=lc05_
Card7=60
Type7=0
NAD7=106
VarPrefix7=lc06_
Card8=60
Type8=0
NAD8=107
VarPrefix8=lc07_
Card9=60
Type9=0
NAD9=108
VarPrefix9=lc08_
Card10=60
Type10=0
NAD10=109
VarPrefix10=lc09_
Card11=60
Type11=0
NAD11=110
VarPrefix11=lc10_
Card12=60
Type12=0
NAD12=111
VarPrefix12=lc11_
Card13=60
Type13=0
NAD13=112
VarPrefix13=lc12_
Card14=60
Type14=0
NAD14=113
VarPrefix14=lc13_
Card15=60
Type15=0
NAD15=114
VarPrefix15=lc14_
Card16=60
Type16=0
NAD16=115
VarPrefix16=lc15_
Card17=60
Type17=0
NAD17=116
VarPrefix17=lc16_
Card18=60
Type18=0
NAD18=117
VarPrefix18=lc17_
Card19=60
Type19=0
NAD19=118
VarPrefix19=lc18_
Card20=60
Type20=0
NAD20=119
VarPrefix20=lc19_

[Net]
PrgDevice00=20031
PrgDevice01=20007
CurrentNAD=20007

[Monitor01]
VarCount=19
VarName1=scene_mode[0]
VarBase1=1
VarValue1=0
VarColor1=0
VarIndex1=0
VarName2=scene_mode[1]
VarBase2=1
VarValue2=0
VarColor2=0
VarIndex2=1
VarName3=scene_mode[2]
VarBase3=1
VarValue3=0
VarColor3=0
VarIndex3=2
VarName4=scene_mark[0]
VarBase4=1
VarValue4=0
VarColor4=0
VarIndex4=3
VarName5=scene_mark[1]
VarBase5=1
VarValue5=0
VarColor5=0
VarIndex5=4
VarName6=scene_mark[2]
VarBase6=1
VarValue6=0
VarColor6=0
VarIndex6=5
VarName7=scene[0]
VarBase7=1
VarValue7=0
VarColor7=0
VarIndex7=6
VarName8=scene[1]
VarBase8=1
VarValue8=0
VarColor8=0
VarIndex8=7
VarName9=scene[2]
VarBase9=1
VarValue9=0
VarColor9=0
VarIndex9=8
VarName10=scene_state[0]
VarBase10=1
VarValue10=0
VarColor10=0
VarIndex10=9
VarName11=scene_state[1]
VarBase11=1
VarValue11=0
VarColor11=0
VarIndex11=10
VarName12=scene_state[2]
VarBase12=1
VarValue12=0
VarColor12=0
VarIndex12=11
VarName13=scene_tout[0]
VarBase13=1
VarValue13=0
VarColor13=0
VarIndex13=12
VarName14=scene_tout[1]
VarBase14=1
VarValue14=0
VarColor14=0
VarIndex14=13
VarName15=scene_tout[2]
VarBase15=1
VarValue15=0
VarColor15=0
VarIndex15=14
VarName16=mscada_active
VarBase16=1
VarValue16=0
VarColor16=0
VarIndex16=15
VarName17=mscada_page
VarBase17=1
VarValue17=0
VarColor17=0
VarIndex17=16
VarName18=mscada_ping
VarBase18=1
VarValue18=0
VarColor18=0
VarIndex18=17
VarName19=main.f_algorithms.f_configure.mscada_timer
VarBase19=1
VarValue19=0
VarColor19=0
VarIndex19=18
#PROJECT_OPTIONS_END

#DMVARSLIST_BEGIN
#DMVARSLIST_END

#MASKS_BEGIN
#MASKS_END

#CODE_BEGIN
// AllocGroupList="User Variables", "I/O Variables", "Constants", "system", "push", "parameters", "events", "inputs", "lights", "scene", "timetable", "low light", "mscada"
var retain
  retentive_magic: int;
  push_enable: bool; default=1; // Allow controller to send periodical push messages to server: 0-off, 1-on. {AllocGroup="push"}
  push_req_counter: long; // Number of push messages sent. Program is configured to send push periodically, once a minute. {AllocGroup="push"}
  push_ack_counter: long; // Number of received acknowledges. Acknowledge confirms that connection to server work in both directions. {AllocGroup="push"}
  push_period: int; default=30; // Period in which push message is sent to server [s]. {AllocGroup="push"}
  parameters_crc_tmp: long; // real-time parameters CRC32 {AllocGroup="parameters"}
  parameters_crc32: long; // delayed parameters CRC32 {AllocGroup="parameters"}
  parameters_autosave: bool; // parameters autosave enabled {AllocGroup="parameters"}
  parameters_crc_preset: int; default=15; // preset time for parameters CRC32 update in minutes {AllocGroup="parameters"}
  application_id: long; // yypppnnn => yy = 2 digits year; ppp = 3 digits project number;         nnn = 3 digits application SN within project {AllocGroup="system"}
  version_major: int; // PLC application major version: increments with functionality changes (functionality redefined, changed main HW components,...) {AllocGroup="system"}
  version_minor: int; // PLC application minor version: increments with cosmetic changes (added variables, updated functionalities, ...) {AllocGroup="system"}
  version_release: int; // PLC application release version: increments with bug & issues fixes {AllocGroup="system"}
  version_state: int; // PLC application major version state: 0=alfa, 1=beta, 2=release candidate, 3=release {AllocGroup="system"}
  kernel_major: int; // kernel major version {AllocGroup="system"}
  kernel_minor: int; // kernel minor version {AllocGroup="system"}
  reset_counter: int; // Total number of controller resets. {AllocGroup="system"}
  operating_hours: long; // Total number of operating hours [h]. {AllocGroup="system"}
  event: ARRAY[0..99] OF long; // {AllocGroup="events"}
  event_date: ARRAY[0..99] OF long; // {AllocGroup="events"}
  event_time: ARRAY[0..99] OF long; // {AllocGroup="events"}
  event_data: ARRAY[0..99] OF long; // {AllocGroup="events"}
  light_short_tout: ARRAY[0..199] OF int; // Light short time-out[s] {AllocGroup="lights"}
  timetable_scene: ARRAY[0..335] OF int; default=-1; // {AllocGroup="timetable"}
  light_tout: ARRAY[0..199] OF int; // Light time-out [min] {AllocGroup="lights"}
  low_light_latitude: int; // Geographic latitude, + north, - south [deg]. {AllocGroup="low light", user}
  low_light_longitude: int; // Geographic longitude, + east, - west [deg]. {AllocGroup="low light", user}
  low_light_time_zone: int; // Difference between local and UTC time, including daylight saving, + east, - west [hours]. {AllocGroup="low light", user}
  low_light_local_offset: int; // Sunrise/sunset correction [minutes]. Positive value move sunrise later and sunset earlier. {AllocGroup="low light", user}
  light_sensor_enable: bool; // Use light sensor to activate low light indicator. When measured lightness is below treshold, indicator will be on, no matter the hours. {AllocGroup="low light", user}
  light_sensor_threshold: int; // Lightness level where low light indicator is activated (0..100%). {AllocGroup="low light", user}
  low_light_status: bool; // Low light status (0-lightness high, 1-lightness low). {AllocGroup="low light"}
  scene_mem: ARRAY[0..9999] OF int; default=-1; // Scene memory (i = scene * 200 + light; value: -1=no effect, 0=off, 1=on) {AllocGroup="scene"}
  selected_light_tout: int; // Light time-out [min] {AllocGroup="mscada"}
  selected_light_long_tout: int; // Light long time-out [min] {AllocGroup="mscada"}
  input_mux: ARRAY[0..199] OF int; // Input multiplex {AllocGroup="inputs"}
  input_low_light: ARRAY[0..199] OF bool; // Input active only at low light {AllocGroup="inputs"}
  light_long_tout: ARRAY[0..199] OF int; // Light long time-out [min] {AllocGroup="lights"}
  scene_sunrise: int; // Scene activated at sunrise (-1=none) {AllocGroup="scene"}
  scene_sunset: int; // Scene activated at sunset (-1=none) {AllocGroup="scene"}
  scene_tout: ARRAY[0..49] OF int; // Scene time-out [min] {AllocGroup="scene"}
  scene_long_tout: ARRAY[0..49] OF int; // Scene long time-out [min] {AllocGroup="scene"}
  scene_short_tout: ARRAY[0..49] OF int; // Scene short time-out [s] {AllocGroup="scene"}
  selected_scene_tout: int; // Scene time-out [min] {AllocGroup="mscada"}
  selected_scene_long_tout: int; // Scene long time-out [min] {AllocGroup="mscada"}
var_end;

var permanent
  ee_parameters: ARRAY[0..1999] OF int; // {AllocGroup="parameters"}
var_end;

var constant
  EV_FP = 1; // {AllocGroup="system"}
  EV_FN = 2; // {AllocGroup="system"}
  EV_LP = 3; // {AllocGroup="system"}
var_end;

var
  i: int;
  j: int;
  push_timer: int; default=30; // Timer for periodically sending push message [s]. {AllocGroup="push"}
  push_req: bool; // Set to send push message and start timer. {AllocGroup="push"}
  push_status: int; // Push status: 0-idle, 1-waiting, 2-ok, 3-error. {AllocGroup="push"}
  push_roundtrip: int; // Time from sending push message to receiving acknowledge [ms]. {AllocGroup="push"}
  parameters_cmd: int; // parameters manipulation command: 1=init, 2=save, 3=read; auto returns to 0 {AllocGroup="parameters"}
  ee_save_req: bool; // save ee_par to eeprom {AllocGroup="parameters"}
  parameters_unsaved_idx: int; // index of first unsaved parameter {AllocGroup="parameters"}
  parameters_crc_timer: long; // parameters CRC32 timer in ms {AllocGroup="parameters"}
  kernel_release: int; // kernel release version {AllocGroup="system"}
  datetime: long; // YYMMDDhhm {AllocGroup="system"}
  date: long; // YYYYMMDD {AllocGroup="system"}
  time: long; // hhmmssddd {AllocGroup="system"}
  cybro_serial: int; // Unique cybro serial number. {AllocGroup="system"}
  cybro_nad: int; // Current cybro A-bus address. {AllocGroup="system"}
  cybro_ip0: int; // Current cybro IP address, 1st byte. {AllocGroup="system"}
  cybro_ip1: int; // Current cybro IP address, 2nd byte. {AllocGroup="system"}
  cybro_ip2: int; // Current cybro IP address, 3rd byte. {AllocGroup="system"}
  cybro_ip3: int; // Current cybro IP address, 4th byte. {AllocGroup="system"}
  cybro_uptime: long; // Number of operating hours since power-on [h]. {AllocGroup="system"}
  minute_of_day: int; // Minutes passed in current day, 0..1439. {AllocGroup="system"}
  day_of_year: int; // Days passed in current year, 1..366. {AllocGroup="system"}
  can_rx_error_counter_max: int; // Maximum value of can receive counter. {AllocGroup="system"}
  can_tx_error_counter_max: int; // Maximum value of can transmit counter. {AllocGroup="system"}
  edit_year: int; // {AllocGroup="system"}
  edit_month: int; // {AllocGroup="system"}
  edit_date: int; // {AllocGroup="system"}
  edit_weekday: int; // {AllocGroup="system"}
  edit_hour: int; // {AllocGroup="system"}
  edit_min: int; // {AllocGroup="system"}
  edit_sec: int; // {AllocGroup="system"}
  datetime_cmd: int; // {AllocGroup="system"}
  edit_datetime: bool; // {AllocGroup="system"}
  event_count: int; // {AllocGroup="events"}
  configurator_page: int; // {AllocGroup="system"}
  parameters_status: int; // parameters status (0=not saved, 1=saved, 2=fatal error) {AllocGroup="parameters"}
  mscada_page: int; // {AllocGroup="mscada"}
  mscada_ping: bool; // {AllocGroup="mscada"}
  mscada_active: bool; // {AllocGroup="mscada"}
  light_sensor_value: int; // Lightness measured by light sensor (0..100%). {AllocGroup="low light"}
  low_light_counter: int; // Use for testing automation events. Low light signal will automatically resume the actual value within 10 seconds. {AllocGroup="low light"}
  sunrise: int; // Calculated sunrise time, minute of day. {AllocGroup="low light"}
  sunset: int; // Calculated sunset time, minute of day. {AllocGroup="low light"}
  sunrise_hour: int; // Calculated sunrise time, hours. {AllocGroup="low light"}
  sunrise_min: int; // Calculated sunrise time, minutes. {AllocGroup="low light"}
  sunset_hour: int; // Calculated sunset time, hours. {AllocGroup="low light"}
  sunset_min: int; // Calculated sunset time, minutes. {AllocGroup="low light"}
  scene: ARRAY[0..49] OF bool; // Scene status (0=inactive, 1=active, 2=not configured) {AllocGroup="scene"}
  scene_cmd: int; default=-1; // Scene command (0-49=toggle scene, 50-99=scene off, 100-149=scene on) {AllocGroup="scene"}
  input_state: ARRAY[0..199] OF int; // {AllocGroup="mscada"}
  light_state: ARRAY[0..199] OF int; // {AllocGroup="mscada"}
  input_select: ARRAY[0..199] OF bool; // {AllocGroup="mscada"}
  light_select: ARRAY[0..199] OF bool; // {AllocGroup="mscada"}
  input_selected: int; default=-1; // {AllocGroup="mscada"}
  light_selected: int; default=-1; // {AllocGroup="mscada"}
  input_mark: ARRAY[0..199] OF int; // Input marking {AllocGroup="mscada"}
  light_mark: ARRAY[0..199] OF int; // Light marking {AllocGroup="mscada"}
  marked_cmd: int; // {AllocGroup="mscada"}
  select_count: int; // {AllocGroup="mscada"}
  input_count: int; // {AllocGroup="mscada"}
  light_count: int; // {AllocGroup="mscada"}
  mask_input: int; // {AllocGroup="mscada"}
  mask_scene: int; // {AllocGroup="mscada"}
  mask_light: int; // {AllocGroup="mscada"}
  txt_idx: int; // {AllocGroup="mscada"}
  scene_state: ARRAY[0..49] OF int; // {AllocGroup="mscada"}
  scene_select: ARRAY[0..49] OF bool; // {AllocGroup="mscada"}
  scene_selected: int; default=-1; // {AllocGroup="mscada"}
  scene_mark: ARRAY[0..49] OF int; // Scene marking {AllocGroup="mscada"}
  scene_count: int; // {AllocGroup="mscada"}
  timetable_state: ARRAY[0..335] OF int; // {AllocGroup="mscada"}
  timetable_select: ARRAY[0..335] OF bool; // {AllocGroup="mscada"}
  timetable_selected: int; default=-1; // {AllocGroup="mscada"}
  timetable_mark: ARRAY[0..335] OF int; // {AllocGroup="mscada"}
  timetable_count: int; // {AllocGroup="mscada"}
  mask_timetable: int; // {AllocGroup="mscada"}
  input: ARRAY[0..199] OF bool; // Input {AllocGroup="inputs"}
  light: ARRAY[0..199] OF bool; // Light state (0=off, 1=on) {AllocGroup="lights"}
  light_mode: ARRAY[0..199] OF int; // Light mode (0=none, 1=button, 2=motion, 3=button+motion, 4=door, 5=door+button, 6=ready-light, 7=ready_light+button) {AllocGroup="lights"}
  light_toggle: ARRAY[0..199] OF bool; // Light toggle input (0=off, 1=on) {AllocGroup="lights"}
  light_extend: ARRAY[0..199] OF bool; // Light time extend input (1=active) {AllocGroup="lights"}
  scene_mode: ARRAY[0..49] OF int; // Scene mode (0=none, 1=button, 2=motion, 3=button+motion, 4=door, 5=door+button, 6=ready-light, 7=ready_light+button) {AllocGroup="scene"}
  scene_toggle: ARRAY[0..49] OF bool; // Scene toggle input (0=off, 1=on) {AllocGroup="scene"}
  scene_extend: ARRAY[0..49] OF bool; // Scene time extend input (1=active) {AllocGroup="scene"}
  scene_inverse: ARRAY[0..49] OF bool; // Scene inverse input (0=opened, 1=closed) {AllocGroup="scene"}
  test: ARRAY[0..9] OF int;
  light_inverse: ARRAY[0..199] OF bool; // Light inverse input (0=opened, 1=closed) {AllocGroup="lights"}
var_end;

function main:void; language 'Structured Text';
  function f_system:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var static
    rtc_ms: int;
    rtc_sec_old: int;
    reset: bool; default=0;
  var_end;

  var
    ip: long; // Temporary IP address for calculations.
  var_end;

    function f_push:void; language 'Structured Text';
    begin
      /*
      
        Push communication with WEB server
      
      */
      
      if fp(clock_1s) then // generate periodic push message
        if push_enable then
          if push_timer>0 then
            push_timer:=push_timer-1;
          else
            push_req:=1;
            push_timer:=push_period-1; // push period [s]
          end_if;
        else
          push_timer:=0;
          push_status:=0; // disabled
        end_if;
      end_if;
      
      if push_req then // new push cycle
        push_req:=0;
        push_status:=1; // waiting
        push_roundtrip:=0;
        push_message_req:=1; // send push message
        push_req_counter:=push_req_counter+1; // transmitted messages
      end_if;
      
      if push_message_ack then // acknowledge received
        push_message_ack:=0;
        push_status:=2; // ok
        push_ack_counter:=push_ack_counter+1; // received messages
      end_if;
      
      if push_status==1 then // waiting for answer
        push_roundtrip:=push_roundtrip+scan_time; // elapsed milliseconds
        if push_roundtrip>=5000 then // server timeout [ms]
          push_roundtrip:=0;
          push_status:=3; // error
        end_if;
      end_if;
      
    end;
    function f_rtc:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      edit_year_old: int;
      edit_month_old: int;
      edit_date_old: int;
      edit_weekday_old: int;
      edit_hour_old: int;
      edit_min_old: int;
      edit_sec_old: int;
      time: long;
    var_end;

    begin
      
      // ****************************************************************************
      // edit date time
      // ****************************************************************************
      
      if edit_year <> edit_year_old or
         edit_month <> edit_month_old or
         edit_date <> edit_date_old or
         edit_weekday <> edit_weekday_old or
         edit_hour <> edit_hour_old or
         edit_min <> edit_min_old or
         edit_sec <> edit_sec_old
      then
        edit_datetime := 1;
      end_if;
      
      if !edit_datetime then
        datetime_cmd := 0;
      end_if;
      
      case datetime_cmd of // set datetime
        1: // set datetime
          rtc_year := edit_year;
          rtc_month := edit_month;
          rtc_date := edit_date;
          rtc_weekday := edit_weekday;
          rtc_hour := edit_hour;
          rtc_min := edit_min;
          rtc_sec := edit_sec;
          rtc_write_req := 1;
          edit_datetime := 0;
        2:  // cancel
          edit_year := rtc_year;
          edit_month := rtc_month;
          edit_date := rtc_date;
          edit_weekday := rtc_weekday;
          edit_hour := rtc_hour;
          edit_min := rtc_min;
          edit_sec := rtc_sec;
          edit_year_old := edit_year;
          edit_month_old := edit_month;
          edit_date_old := edit_date;
          edit_weekday_old := edit_weekday;
          edit_hour_old := edit_hour;
          edit_min_old := edit_min;
          edit_sec_old := edit_sec;
          edit_datetime := 0;
      end_case;
      datetime_cmd := 0;
      
      if !edit_datetime then
        edit_year := rtc_year;
        edit_month := rtc_month;
        edit_date := rtc_date;
        edit_weekday := rtc_weekday;
        edit_hour := rtc_hour;
        edit_min := rtc_min;
        edit_sec := rtc_sec;
        edit_year_old := edit_year;
        edit_month_old := edit_month;
        edit_date_old := edit_date;
        edit_weekday_old := edit_weekday;
        edit_hour_old := edit_hour;
        edit_min_old := edit_min;
        edit_sec_old := edit_sec;
      end_if;
      
    end;
    function f_log_event(ev,dt:long):void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var
      li: int;
    var_end;

    begin
      
      // move log data
      for li := 0 to 98 do
        event[99-li] := event[98-li];
        event_data[99-li] := event_data[98-li];
        event_date[99-li] := event_date[98-li];
        event_time[99-li] := event_time[98-li];
      end_for;
      
      event[0] := ev;
      event_date[0] := date;
      event_time[0] := time;
      event_data[0] := dt;
      
      event_count := event_count + 1;
      if event_count > 9999 then
        event_count := 0;
      end_if;
    end;
  begin
    
    // ****************************************************************************
    // system info
    // ****************************************************************************
    // Application ID
    // yypppnnn => yy  2 digits year
    //             ppp 3 digits project number
    //             nnn 3 digits application SN within project
    application_id := 21000000;
    // Version number
    version_major   := 0; // major changes: added functionality, changed main HW components, ...
    version_minor   := 0; // cosmetic changes: added variables, updated functionalities, ...
    version_release := 0; // bug & issues fixes, ...
    // Version state
    // 0=alfa, 1=beta, 2=release candidate, 3=release
    version_state   := 0;
    // CyBro kernel version
    kernel_major   := 3;
    kernel_minor   := 0;
    kernel_release := 7;
    
    f_push();
    
    f_rtc();
    
    // YYMMDDhhm
    datetime := long(rtc_year % 100) *  10000000 +
                long(rtc_month) * 100000 +
                long(rtc_date) *  1000 +
                long(rtc_hour) *  10 +
                long(rtc_min) / 10;
    
    // yyyymmdd
    date := long(rtc_year) *  10000 +
            long(rtc_month) * 100 +
            long(rtc_date);
    
    // hhmmdddd
    rtc_ms := rtc_ms + scan_time;
    if rtc_sec <> rtc_sec_old then
      rtc_ms := 0;
    end_if;
    rtc_sec_old := rtc_sec;
    
    time := long(rtc_hour) * 10000000 +
            long(rtc_min)  * 100000 +
            long(rtc_sec)  * 1000 +
            long(rtc_ms);
    
    // nad and serial number
    cybro_nad := int(get_nad());
    cybro_serial := int(get_serial());
    
    // ip address
    ip := get_ip();
    if ip >= 0 then
      cybro_ip0 := int(ip shr 24);
    else
      ip := ip + 16#80000000;
      cybro_ip0 := int(ip shr 24) + 128;
    end_if;
    cybro_ip1 := int((ip shr 16) and 255);
    cybro_ip2 := int((ip shr 8) and 255);
    cybro_ip3 := int(ip and 255);
    
    // reset counter and retentive memory check
    if !reset then
      reset_counter := reset_counter + 1;
      f_log_event(001001000, reset_counter);
      reset := 1;
    end_if;
    
    // once per hour increment cybro uptime and operating hours
    if fp(rtc_min == 0) then
      cybro_uptime := cybro_uptime + 1;
      operating_hours := operating_hours + 1;
    end_if;
    
    // minute of day (0..1439) and day of year (1..366)
    minute_of_day := rtc_hour * 60 + rtc_min;
    day_of_year := int(275 * rtc_month / 9) - 2 * int((rtc_month + 9) / 12) + rtc_date - 30;
    
    // can error counters
    if can_rx_error_counter > can_rx_error_counter_max then
      can_rx_error_counter_max := can_rx_error_counter;
    end_if;
    
    if can_tx_error_counter > can_tx_error_counter_max then
      can_tx_error_counter_max := can_tx_error_counter;
    end_if;
    
    // prevent accidental activation
    disconnect_inputs := 0;
    
    // configurator page
    if configurator_page = 0 then
      configurator_page := 1;
    end_if;
  end;
  function f_parameters:void; language 'Structured Text';
  // AllocGroupList="User Variables"
  var static
    p_i: int;
  var_end;

  var retain
    parameters_crc_tmp_old: long;
  var_end;

    function f_parameters_manage(idx,val,def,min,max:int):int; language 'Structured Text';
    begin
      //*****************************************************************************
      // f_parameters_manage(ee_array_index, value, default_value, min_value, max_value, command)
      //*****************************************************************************
      
      if idx <= 1999 then
      
        // test ee
        if ee_parameters[idx] < min then
          ee_parameters[idx] := min;
          ee_save_req := 1;
        elsif ee_parameters[idx] > max then
          ee_parameters[idx] := max;
          ee_save_req := 1;
        end_if;
      
        // execute command
        case parameters_cmd of
          1 : // init
            result := def;
            ee_parameters[idx] := def;
            ee_save_req := 1;
          2 : // save
            result := val;
            ee_parameters[idx] := val;
            ee_save_req := 1;
          3 : // load
            result := ee_parameters[idx];
        else
          result := val;
        end_case;
      
        // test parameter
        if result < min then
          result := min;
        elsif result > max then
          result := max;
        end_if;
      
        // test if saved
        if result <> ee_parameters[idx] then
          parameters_status := 0;
          parameters_unsaved_idx := idx;
        end_if;
      
        // crc 32 calc
        parameters_crc_tmp := f_crc_32_update(parameters_crc_tmp,result);
      
      end_if;
      
      // set next EE address
      p_i := p_i + 1;
      
      if p_i > 1999 then
        parameters_status := 2; // fatal error
      end_if;
      
    end;
    function f_crc_32_update(crc,val:long):long; language 'Structured Text';
    // AllocGroupList="User Variables"
    var retain
      lj: int;
    var_end;

    begin
      
      
      result := crc xor val;
      for lj := 1 to 8 do
        if (result and 1) <> 0 then
          result := (result shr 1) xor 16#EDB88320;
        else
          result := (result shr 1);
        end_if;
      end_for;
      
    end;
  begin
    
    if !ee_read_req and !ee_write_req then
    
      // init general parameters statuses
      parameters_status := 1;
      parameters_unsaved_idx := -1;
    
      // if retentive fail then read from ee
      if retentive_magic <> 31415 then
        parameters_cmd := 3; // read from ee
        retentive_magic := 31415;
      end_if;
    
      // init parameters when EE is empty (only new controllers)
      if ee_parameters[0] <> 31415 then
        parameters_cmd := 1; // init
        ee_parameters[0] := 31415;
      end_if;
    
      //*********************************************************************************************************************
    
      // CRC32 init
      parameters_crc_tmp := 16#FFFFFFFF;
    
      p_i := 1; // set 1st EE location
    
      // system
      push_enable := bit(f_parameters_manage( p_i,push_enable,1,0,1));
      push_period := f_parameters_manage( p_i,push_period,30,30,300); // s
    
      parameters_autosave := bit(f_parameters_manage( p_i,parameters_autosave,1,0,1));
    
      // low light
      low_light_time_zone := int(f_parameters_manage( p_i,low_light_time_zone,1,-12,12));
      low_light_latitude := int(f_parameters_manage( p_i,low_light_latitude,46,-65,65));
      low_light_longitude := int(f_parameters_manage( p_i,low_light_longitude,14,-180,180));
      low_light_local_offset := int(f_parameters_manage( p_i,low_light_local_offset,0,-999,999));
    
      scene_sunrise := int(f_parameters_manage( p_i,scene_sunrise,-1,-1,49));
      scene_sunset := int(f_parameters_manage( p_i,scene_sunset,-1,-1,49));
    
      // inputs
      for i := 0 to 199 do
        input_mux[i] := f_parameters_manage( p_i,input_mux[i],i*100+11,0,19900);
        input_low_light[i] := bit(f_parameters_manage( p_i,input_low_light[i],0,0,1));
      end_for;
    
      // lights
      for i := 0 to 199 do
        light_short_tout[i] := bit(f_parameters_manage( p_i,light_short_tout[i],10,0,32767));  // s - for ready light
        light_tout[i] := f_parameters_manage( p_i,light_tout[i],0,0,32767);                    // m
        light_long_tout[i] := bit(f_parameters_manage( p_i,light_long_tout[i],0,0,32767));     // m
      end_for;
    
      test[0] := p_i;
      // scenes
      for i := 0 to 49 do
        scene_short_tout[i] := bit(f_parameters_manage( p_i,scene_short_tout[i],10,0,32767));  // s - for ready light
        scene_tout[i] := f_parameters_manage( p_i,scene_tout[i],0,0,32767);                    // m
        scene_long_tout[i] := bit(f_parameters_manage( p_i,scene_long_tout[i],0,0,32767));     // m
      end_for;
    
      // finish crc 32 calc
      parameters_crc_tmp := !parameters_crc_tmp;
    
      //*********************************************************************************************************************
    
      // save ee_par
      if ee_save_req then
        ee_write_magic := 31415;
        ee_write_req := 1;
      end_if;
      ee_save_req := 0;
    
      // init non ee parameters
      if parameters_cmd = 1 then
        // scenes
        for i := 0 to 9999 do
          scene_mem[i] := -1;
        end_for;
        // timetable
        for i := 0 to 335 do
          timetable_scene[i] := -1;
        end_for;
      end_if;
    
      if parameters_cmd <> 0 then
        parameters_crc32 := parameters_crc_tmp;
      end_if;
    
      // clear command
      parameters_cmd := 0;
    
    end_if;
    
    // parameters crc32 calculations
    
    if parameters_crc_tmp = parameters_crc_tmp_old and parameters_crc_tmp <> parameters_crc32 then
      parameters_crc_timer := parameters_crc_timer + scan_time;
    else
      parameters_crc_timer := 0;
    end_if;
    parameters_crc_tmp_old := parameters_crc_tmp;
    
    if parameters_crc_timer >= (long(15)*60*1000) or parameters_crc_tmp = 650399394 then
      parameters_crc32 := parameters_crc_tmp;
      if parameters_autosave then
        parameters_cmd := 2;
      end_if;
    end_if;
    
    
  end;
  function f_io_mux:void; language 'Structured Text';
  begin
    // ****************************************************************************
    //  inputs
    // ****************************************************************************
    
    if lc00_general_error then
      input[0] := bit(2);
      input[1] := bit(2);
      input[2] := bit(2);
      input[3] := bit(2);
      input[4] := bit(2);
      input[5] := bit(2);
      input[6] := bit(2);
      input[7] := bit(2);
      input[8] := bit(2);
      input[9] := bit(2);
      light[0] := bit(2);
      light[1] := bit(2);
      light[2] := bit(2);
      light[3] := bit(2);
      light[4] := bit(2);
      light[5] := bit(2);
      light[6] := bit(2);
      light[7] := bit(2);
      light[8] := bit(2);
      light[9] := bit(2);
      lc00_qx00 := 0;
      lc00_qx01 := 0;
      lc00_qx02 := 0;
      lc00_qx03 := 0;
      lc00_qx04 := 0;
      lc00_qx05 := 0;
      lc00_qx06 := 0;
      lc00_qx07 := 0;
      lc00_qx08 := 0;
      lc00_qx09 := 0;
    else
      if lc00_input_mode_00 < 7 or
         lc00_input_mode_01 < 7 or
         lc00_input_mode_02 < 7 or
         lc00_input_mode_03 < 7 or
         lc00_input_mode_04 < 7 or
         lc00_input_mode_05 < 7 or
         lc00_input_mode_06 < 7 or
         lc00_input_mode_07 < 7 or
         lc00_input_mode_08 < 7 or
         lc00_input_mode_09 < 7
      then
        lc00_input_mode_data := 7;
        lc00_input_mode_index := -1;
        lc00_input_mode_req := 1;
      end_if;
      if lc00_output_mode_00 > 0 or
         lc00_output_mode_01 > 0 or
         lc00_output_mode_02 > 0 or
         lc00_output_mode_03 > 0 or
         lc00_output_mode_04 > 0 or
         lc00_output_mode_05 > 0 or
         lc00_output_mode_06 > 0 or
         lc00_output_mode_07 > 0 or
         lc00_output_mode_08 > 0 or
         lc00_output_mode_09 > 0
      then
        lc00_output_mode_data := 0;
        lc00_output_mode_index := -1;
        lc00_output_mode_req := 1;
      end_if;
      input[0] := lc00_ix00;
      input[1] := lc00_ix01;
      input[2] := lc00_ix02;
      input[3] := lc00_ix03;
      input[4] := lc00_ix04;
      input[5] := lc00_ix05;
      input[6] := lc00_ix06;
      input[7] := lc00_ix07;
      input[8] := lc00_ix08;
      input[9] := lc00_ix09;
      lc00_qx00 := light[0];
      lc00_qx01 := light[1];
      lc00_qx02 := light[2];
      lc00_qx03 := light[3];
      lc00_qx04 := light[4];
      lc00_qx05 := light[5];
      lc00_qx06 := light[6];
      lc00_qx07 := light[7];
      lc00_qx08 := light[8];
      lc00_qx09 := light[9];
    end_if;
    
    if lc01_general_error then
      input[10] := bit(2);
      input[11] := bit(2);
      input[12] := bit(2);
      input[13] := bit(2);
      input[14] := bit(2);
      input[15] := bit(2);
      input[16] := bit(2);
      input[17] := bit(2);
      input[18] := bit(2);
      input[19] := bit(2);
      light[10] := bit(2);
      light[11] := bit(2);
      light[12] := bit(2);
      light[13] := bit(2);
      light[14] := bit(2);
      light[15] := bit(2);
      light[16] := bit(2);
      light[17] := bit(2);
      light[18] := bit(2);
      light[19] := bit(2);
      lc01_qx00 := 0;
      lc01_qx01 := 0;
      lc01_qx02 := 0;
      lc01_qx03 := 0;
      lc01_qx04 := 0;
      lc01_qx05 := 0;
      lc01_qx06 := 0;
      lc01_qx07 := 0;
      lc01_qx08 := 0;
      lc01_qx09 := 0;
    else
      if lc01_output_mode_00 > 0 or
         lc01_output_mode_01 > 0 or
         lc01_output_mode_02 > 0 or
         lc01_output_mode_03 > 0 or
         lc01_output_mode_04 > 0 or
         lc01_output_mode_05 > 0 or
         lc01_output_mode_06 > 0 or
         lc01_output_mode_07 > 0 or
         lc01_output_mode_08 > 0 or
         lc01_output_mode_09 > 0
      then
        lc01_output_mode_data := 0;
        lc01_output_mode_index := -1;
        lc01_output_mode_req := 1;
      end_if;
      input[10] := lc01_ix00;
      input[11] := lc01_ix01;
      input[12] := lc01_ix02;
      input[13] := lc01_ix03;
      input[14] := lc01_ix04;
      input[15] := lc01_ix05;
      input[16] := lc01_ix06;
      input[17] := lc01_ix07;
      input[18] := lc01_ix08;
      input[19] := lc01_ix09;
      lc01_qx00 := light[10];
      lc01_qx01 := light[11];
      lc01_qx02 := light[12];
      lc01_qx03 := light[13];
      lc01_qx04 := light[14];
      lc01_qx05 := light[15];
      lc01_qx06 := light[16];
      lc01_qx07 := light[17];
      lc01_qx08 := light[18];
      lc01_qx09 := light[19];
    end_if;
    
    if lc02_general_error then
      input[20] := bit(2);
      input[21] := bit(2);
      input[22] := bit(2);
      input[23] := bit(2);
      input[24] := bit(2);
      input[25] := bit(2);
      input[26] := bit(2);
      input[27] := bit(2);
      input[28] := bit(2);
      input[29] := bit(2);
      light[20] := bit(2);
      light[21] := bit(2);
      light[22] := bit(2);
      light[23] := bit(2);
      light[24] := bit(2);
      light[25] := bit(2);
      light[26] := bit(2);
      light[27] := bit(2);
      light[28] := bit(2);
      light[29] := bit(2);
      lc02_qx00 := 0;
      lc02_qx01 := 0;
      lc02_qx02 := 0;
      lc02_qx03 := 0;
      lc02_qx04 := 0;
      lc02_qx05 := 0;
      lc02_qx06 := 0;
      lc02_qx07 := 0;
      lc02_qx08 := 0;
      lc02_qx09 := 0;
    else
      if lc02_output_mode_00 > 0 or
         lc02_output_mode_01 > 0 or
         lc02_output_mode_02 > 0 or
         lc02_output_mode_03 > 0 or
         lc02_output_mode_04 > 0 or
         lc02_output_mode_05 > 0 or
         lc02_output_mode_06 > 0 or
         lc02_output_mode_07 > 0 or
         lc02_output_mode_08 > 0 or
         lc02_output_mode_09 > 0
      then
        lc02_output_mode_data := 0;
        lc02_output_mode_index := -1;
        lc02_output_mode_req := 1;
      end_if;
      input[20] := lc02_ix00;
      input[21] := lc02_ix01;
      input[22] := lc02_ix02;
      input[23] := lc02_ix03;
      input[24] := lc02_ix04;
      input[25] := lc02_ix05;
      input[26] := lc02_ix06;
      input[27] := lc02_ix07;
      input[28] := lc02_ix08;
      input[29] := lc02_ix09;
      lc02_qx00 := light[20];
      lc02_qx01 := light[21];
      lc02_qx02 := light[22];
      lc02_qx03 := light[23];
      lc02_qx04 := light[24];
      lc02_qx05 := light[25];
      lc02_qx06 := light[26];
      lc02_qx07 := light[27];
      lc02_qx08 := light[28];
      lc02_qx09 := light[29];
    end_if;
    
    if lc03_general_error then
      input[30] := bit(2);
      input[31] := bit(2);
      input[32] := bit(2);
      input[33] := bit(2);
      input[34] := bit(2);
      input[35] := bit(2);
      input[36] := bit(2);
      input[37] := bit(2);
      input[38] := bit(2);
      input[39] := bit(2);
      light[30] := bit(2);
      light[31] := bit(2);
      light[32] := bit(2);
      light[33] := bit(2);
      light[34] := bit(2);
      light[35] := bit(2);
      light[36] := bit(2);
      light[37] := bit(2);
      light[38] := bit(2);
      light[39] := bit(2);
      lc03_qx00 := 0;
      lc03_qx01 := 0;
      lc03_qx02 := 0;
      lc03_qx03 := 0;
      lc03_qx04 := 0;
      lc03_qx05 := 0;
      lc03_qx06 := 0;
      lc03_qx07 := 0;
      lc03_qx08 := 0;
      lc03_qx09 := 0;
    else
      if lc03_output_mode_00 > 0 or
         lc03_output_mode_01 > 0 or
         lc03_output_mode_02 > 0 or
         lc03_output_mode_03 > 0 or
         lc03_output_mode_04 > 0 or
         lc03_output_mode_05 > 0 or
         lc03_output_mode_06 > 0 or
         lc03_output_mode_07 > 0 or
         lc03_output_mode_08 > 0 or
         lc03_output_mode_09 > 0
      then
        lc03_output_mode_data := 0;
        lc03_output_mode_index := -1;
        lc03_output_mode_req := 1;
      end_if;
      input[30] := lc03_ix00;
      input[31] := lc03_ix01;
      input[32] := lc03_ix02;
      input[33] := lc03_ix03;
      input[34] := lc03_ix04;
      input[35] := lc03_ix05;
      input[36] := lc03_ix06;
      input[37] := lc03_ix07;
      input[38] := lc03_ix08;
      input[39] := lc03_ix09;
      lc03_qx00 := light[30];
      lc03_qx01 := light[31];
      lc03_qx02 := light[32];
      lc03_qx03 := light[33];
      lc03_qx04 := light[34];
      lc03_qx05 := light[35];
      lc03_qx06 := light[36];
      lc03_qx07 := light[37];
      lc03_qx08 := light[38];
      lc03_qx09 := light[39];
    end_if;
    
    if lc04_general_error then
      input[40] := bit(2);
      input[41] := bit(2);
      input[42] := bit(2);
      input[43] := bit(2);
      input[44] := bit(2);
      input[45] := bit(2);
      input[46] := bit(2);
      input[47] := bit(2);
      input[48] := bit(2);
      input[49] := bit(2);
      light[40] := bit(2);
      light[41] := bit(2);
      light[42] := bit(2);
      light[43] := bit(2);
      light[44] := bit(2);
      light[45] := bit(2);
      light[46] := bit(2);
      light[47] := bit(2);
      light[48] := bit(2);
      light[49] := bit(2);
      lc04_qx00 := 0;
      lc04_qx01 := 0;
      lc04_qx02 := 0;
      lc04_qx03 := 0;
      lc04_qx04 := 0;
      lc04_qx05 := 0;
      lc04_qx06 := 0;
      lc04_qx07 := 0;
      lc04_qx08 := 0;
      lc04_qx09 := 0;
    else
      if lc04_output_mode_00 > 0 or
         lc04_output_mode_01 > 0 or
         lc04_output_mode_02 > 0 or
         lc04_output_mode_03 > 0 or
         lc04_output_mode_04 > 0 or
         lc04_output_mode_05 > 0 or
         lc04_output_mode_06 > 0 or
         lc04_output_mode_07 > 0 or
         lc04_output_mode_08 > 0 or
         lc04_output_mode_09 > 0
      then
        lc04_output_mode_data := 0;
        lc04_output_mode_index := -1;
        lc04_output_mode_req := 1;
      end_if;
      input[40] := lc04_ix00;
      input[41] := lc04_ix01;
      input[42] := lc04_ix02;
      input[43] := lc04_ix03;
      input[44] := lc04_ix04;
      input[45] := lc04_ix05;
      input[46] := lc04_ix06;
      input[47] := lc04_ix07;
      input[48] := lc04_ix08;
      input[49] := lc04_ix09;
      lc04_qx00 := light[40];
      lc04_qx01 := light[41];
      lc04_qx02 := light[42];
      lc04_qx03 := light[43];
      lc04_qx04 := light[44];
      lc04_qx05 := light[45];
      lc04_qx06 := light[46];
      lc04_qx07 := light[47];
      lc04_qx08 := light[48];
      lc04_qx09 := light[49];
    end_if;
    
    if lc05_general_error then
      input[50] := bit(2);
      input[51] := bit(2);
      input[52] := bit(2);
      input[53] := bit(2);
      input[54] := bit(2);
      input[55] := bit(2);
      input[56] := bit(2);
      input[57] := bit(2);
      input[58] := bit(2);
      input[59] := bit(2);
      light[50] := bit(2);
      light[51] := bit(2);
      light[52] := bit(2);
      light[53] := bit(2);
      light[54] := bit(2);
      light[55] := bit(2);
      light[56] := bit(2);
      light[57] := bit(2);
      light[58] := bit(2);
      light[59] := bit(2);
      lc05_qx00 := 0;
      lc05_qx01 := 0;
      lc05_qx02 := 0;
      lc05_qx03 := 0;
      lc05_qx04 := 0;
      lc05_qx05 := 0;
      lc05_qx06 := 0;
      lc05_qx07 := 0;
      lc05_qx08 := 0;
      lc05_qx09 := 0;
    else
      if lc05_output_mode_00 > 0 or
         lc05_output_mode_01 > 0 or
         lc05_output_mode_02 > 0 or
         lc05_output_mode_03 > 0 or
         lc05_output_mode_04 > 0 or
         lc05_output_mode_05 > 0 or
         lc05_output_mode_06 > 0 or
         lc05_output_mode_07 > 0 or
         lc05_output_mode_08 > 0 or
         lc05_output_mode_09 > 0
      then
        lc05_output_mode_data := 0;
        lc05_output_mode_index := -1;
        lc05_output_mode_req := 1;
      end_if;
      input[50] := lc05_ix00;
      input[51] := lc05_ix01;
      input[52] := lc05_ix02;
      input[53] := lc05_ix03;
      input[54] := lc05_ix04;
      input[55] := lc05_ix05;
      input[56] := lc05_ix06;
      input[57] := lc05_ix07;
      input[58] := lc05_ix08;
      input[59] := lc05_ix09;
      lc05_qx00 := light[50];
      lc05_qx01 := light[51];
      lc05_qx02 := light[52];
      lc05_qx03 := light[53];
      lc05_qx04 := light[54];
      lc05_qx05 := light[55];
      lc05_qx06 := light[56];
      lc05_qx07 := light[57];
      lc05_qx08 := light[58];
      lc05_qx09 := light[59];
    end_if;
    
    if lc06_general_error then
      input[60] := bit(2);
      input[61] := bit(2);
      input[62] := bit(2);
      input[63] := bit(2);
      input[64] := bit(2);
      input[65] := bit(2);
      input[66] := bit(2);
      input[67] := bit(2);
      input[68] := bit(2);
      input[69] := bit(2);
      light[60] := bit(2);
      light[61] := bit(2);
      light[62] := bit(2);
      light[63] := bit(2);
      light[64] := bit(2);
      light[65] := bit(2);
      light[66] := bit(2);
      light[67] := bit(2);
      light[68] := bit(2);
      light[69] := bit(2);
      lc06_qx00 := 0;
      lc06_qx01 := 0;
      lc06_qx02 := 0;
      lc06_qx03 := 0;
      lc06_qx04 := 0;
      lc06_qx05 := 0;
      lc06_qx06 := 0;
      lc06_qx07 := 0;
      lc06_qx08 := 0;
      lc06_qx09 := 0;
    else
      if lc06_output_mode_00 > 0 or
         lc06_output_mode_01 > 0 or
         lc06_output_mode_02 > 0 or
         lc06_output_mode_03 > 0 or
         lc06_output_mode_04 > 0 or
         lc06_output_mode_05 > 0 or
         lc06_output_mode_06 > 0 or
         lc06_output_mode_07 > 0 or
         lc06_output_mode_08 > 0 or
         lc06_output_mode_09 > 0
      then
        lc06_output_mode_data := 0;
        lc06_output_mode_index := -1;
        lc06_output_mode_req := 1;
      end_if;
      input[60] := lc06_ix00;
      input[61] := lc06_ix01;
      input[62] := lc06_ix02;
      input[63] := lc06_ix03;
      input[64] := lc06_ix04;
      input[65] := lc06_ix05;
      input[66] := lc06_ix06;
      input[67] := lc06_ix07;
      input[68] := lc06_ix08;
      input[69] := lc06_ix09;
      lc06_qx00 := light[60];
      lc06_qx01 := light[61];
      lc06_qx02 := light[62];
      lc06_qx03 := light[63];
      lc06_qx04 := light[64];
      lc06_qx05 := light[65];
      lc06_qx06 := light[66];
      lc06_qx07 := light[67];
      lc06_qx08 := light[68];
      lc06_qx09 := light[69];
    end_if;
    
    if lc07_general_error then
      input[70] := bit(2);
      input[71] := bit(2);
      input[72] := bit(2);
      input[73] := bit(2);
      input[74] := bit(2);
      input[75] := bit(2);
      input[76] := bit(2);
      input[77] := bit(2);
      input[78] := bit(2);
      input[79] := bit(2);
      light[70] := bit(2);
      light[71] := bit(2);
      light[72] := bit(2);
      light[73] := bit(2);
      light[74] := bit(2);
      light[75] := bit(2);
      light[76] := bit(2);
      light[77] := bit(2);
      light[78] := bit(2);
      light[79] := bit(2);
      lc07_qx00 := 0;
      lc07_qx01 := 0;
      lc07_qx02 := 0;
      lc07_qx03 := 0;
      lc07_qx04 := 0;
      lc07_qx05 := 0;
      lc07_qx06 := 0;
      lc07_qx07 := 0;
      lc07_qx08 := 0;
      lc07_qx09 := 0;
    else
      if lc07_output_mode_00 > 0 or
         lc07_output_mode_01 > 0 or
         lc07_output_mode_02 > 0 or
         lc07_output_mode_03 > 0 or
         lc07_output_mode_04 > 0 or
         lc07_output_mode_05 > 0 or
         lc07_output_mode_06 > 0 or
         lc07_output_mode_07 > 0 or
         lc07_output_mode_08 > 0 or
         lc07_output_mode_09 > 0
      then
        lc07_output_mode_data := 0;
        lc07_output_mode_index := -1;
        lc07_output_mode_req := 1;
      end_if;
      input[70] := lc07_ix00;
      input[71] := lc07_ix01;
      input[72] := lc07_ix02;
      input[73] := lc07_ix03;
      input[74] := lc07_ix04;
      input[75] := lc07_ix05;
      input[76] := lc07_ix06;
      input[77] := lc07_ix07;
      input[78] := lc07_ix08;
      input[79] := lc07_ix09;
      lc07_qx00 := light[70];
      lc07_qx01 := light[71];
      lc07_qx02 := light[72];
      lc07_qx03 := light[73];
      lc07_qx04 := light[74];
      lc07_qx05 := light[75];
      lc07_qx06 := light[76];
      lc07_qx07 := light[77];
      lc07_qx08 := light[78];
      lc07_qx09 := light[79];
    end_if;
    
    if lc08_general_error then
      input[80] := bit(2);
      input[81] := bit(2);
      input[82] := bit(2);
      input[83] := bit(2);
      input[84] := bit(2);
      input[85] := bit(2);
      input[86] := bit(2);
      input[87] := bit(2);
      input[88] := bit(2);
      input[89] := bit(2);
      light[80] := bit(2);
      light[81] := bit(2);
      light[82] := bit(2);
      light[83] := bit(2);
      light[84] := bit(2);
      light[85] := bit(2);
      light[86] := bit(2);
      light[87] := bit(2);
      light[88] := bit(2);
      light[89] := bit(2);
      lc08_qx00 := 0;
      lc08_qx01 := 0;
      lc08_qx02 := 0;
      lc08_qx03 := 0;
      lc08_qx04 := 0;
      lc08_qx05 := 0;
      lc08_qx06 := 0;
      lc08_qx07 := 0;
      lc08_qx08 := 0;
      lc08_qx09 := 0;
    else
      if lc08_output_mode_00 > 0 or
         lc08_output_mode_01 > 0 or
         lc08_output_mode_02 > 0 or
         lc08_output_mode_03 > 0 or
         lc08_output_mode_04 > 0 or
         lc08_output_mode_05 > 0 or
         lc08_output_mode_06 > 0 or
         lc08_output_mode_07 > 0 or
         lc08_output_mode_08 > 0 or
         lc08_output_mode_09 > 0
      then
        lc08_output_mode_data := 0;
        lc08_output_mode_index := -1;
        lc08_output_mode_req := 1;
      end_if;
      input[80] := lc08_ix00;
      input[81] := lc08_ix01;
      input[82] := lc08_ix02;
      input[83] := lc08_ix03;
      input[84] := lc08_ix04;
      input[85] := lc08_ix05;
      input[86] := lc08_ix06;
      input[87] := lc08_ix07;
      input[88] := lc08_ix08;
      input[89] := lc08_ix09;
      lc08_qx00 := light[80];
      lc08_qx01 := light[81];
      lc08_qx02 := light[82];
      lc08_qx03 := light[83];
      lc08_qx04 := light[84];
      lc08_qx05 := light[85];
      lc08_qx06 := light[86];
      lc08_qx07 := light[87];
      lc08_qx08 := light[88];
      lc08_qx09 := light[89];
    end_if;
    
    if lc09_general_error then
      input[90] := bit(2);
      input[91] := bit(2);
      input[92] := bit(2);
      input[93] := bit(2);
      input[94] := bit(2);
      input[95] := bit(2);
      input[96] := bit(2);
      input[97] := bit(2);
      input[98] := bit(2);
      input[99] := bit(2);
      light[90] := bit(2);
      light[91] := bit(2);
      light[92] := bit(2);
      light[93] := bit(2);
      light[94] := bit(2);
      light[95] := bit(2);
      light[96] := bit(2);
      light[97] := bit(2);
      light[98] := bit(2);
      light[99] := bit(2);
      lc09_qx00 := 0;
      lc09_qx01 := 0;
      lc09_qx02 := 0;
      lc09_qx03 := 0;
      lc09_qx04 := 0;
      lc09_qx05 := 0;
      lc09_qx06 := 0;
      lc09_qx07 := 0;
      lc09_qx08 := 0;
      lc09_qx09 := 0;
    else
      if lc09_output_mode_00 > 0 or
         lc09_output_mode_01 > 0 or
         lc09_output_mode_02 > 0 or
         lc09_output_mode_03 > 0 or
         lc09_output_mode_04 > 0 or
         lc09_output_mode_05 > 0 or
         lc09_output_mode_06 > 0 or
         lc09_output_mode_07 > 0 or
         lc09_output_mode_08 > 0 or
         lc09_output_mode_09 > 0
      then
        lc09_output_mode_data := 0;
        lc09_output_mode_index := -1;
        lc09_output_mode_req := 1;
      end_if;
      input[90] := lc09_ix00;
      input[91] := lc09_ix01;
      input[92] := lc09_ix02;
      input[93] := lc09_ix03;
      input[94] := lc09_ix04;
      input[95] := lc09_ix05;
      input[96] := lc09_ix06;
      input[97] := lc09_ix07;
      input[98] := lc09_ix08;
      input[99] := lc09_ix09;
      lc09_qx00 := light[90];
      lc09_qx01 := light[91];
      lc09_qx02 := light[92];
      lc09_qx03 := light[93];
      lc09_qx04 := light[94];
      lc09_qx05 := light[95];
      lc09_qx06 := light[96];
      lc09_qx07 := light[97];
      lc09_qx08 := light[98];
      lc09_qx09 := light[99];
    end_if;
    
    // ****************************************************************************
    //  inputs
    // ****************************************************************************
    
    if lc10_general_error then
      input[100] := bit(2);
      input[101] := bit(2);
      input[102] := bit(2);
      input[103] := bit(2);
      input[104] := bit(2);
      input[105] := bit(2);
      input[106] := bit(2);
      input[107] := bit(2);
      input[108] := bit(2);
      input[109] := bit(2);
      light[100] := bit(2);
      light[101] := bit(2);
      light[102] := bit(2);
      light[103] := bit(2);
      light[104] := bit(2);
      light[105] := bit(2);
      light[106] := bit(2);
      light[107] := bit(2);
      light[108] := bit(2);
      light[109] := bit(2);
      lc10_qx00 := 0;
      lc10_qx01 := 0;
      lc10_qx02 := 0;
      lc10_qx03 := 0;
      lc10_qx04 := 0;
      lc10_qx05 := 0;
      lc10_qx06 := 0;
      lc10_qx07 := 0;
      lc10_qx08 := 0;
      lc10_qx09 := 0;
    else
      if lc10_output_mode_00 > 0 or
         lc10_output_mode_01 > 0 or
         lc10_output_mode_02 > 0 or
         lc10_output_mode_03 > 0 or
         lc10_output_mode_04 > 0 or
         lc10_output_mode_05 > 0 or
         lc10_output_mode_06 > 0 or
         lc10_output_mode_07 > 0 or
         lc10_output_mode_08 > 0 or
         lc10_output_mode_09 > 0
      then
        lc10_output_mode_data := 0;
        lc10_output_mode_index := -1;
        lc10_output_mode_req := 1;
      end_if;
      input[100] := lc10_ix00;
      input[101] := lc10_ix01;
      input[102] := lc10_ix02;
      input[103] := lc10_ix03;
      input[104] := lc10_ix04;
      input[105] := lc10_ix05;
      input[106] := lc10_ix06;
      input[107] := lc10_ix07;
      input[108] := lc10_ix08;
      input[109] := lc10_ix09;
      lc10_qx00 := light[100];
      lc10_qx01 := light[101];
      lc10_qx02 := light[102];
      lc10_qx03 := light[103];
      lc10_qx04 := light[104];
      lc10_qx05 := light[105];
      lc10_qx06 := light[106];
      lc10_qx07 := light[107];
      lc10_qx08 := light[108];
      lc10_qx09 := light[109];
    end_if;
    
    if lc11_general_error then
      input[110] := bit(2);
      input[111] := bit(2);
      input[112] := bit(2);
      input[113] := bit(2);
      input[114] := bit(2);
      input[115] := bit(2);
      input[116] := bit(2);
      input[117] := bit(2);
      input[118] := bit(2);
      input[119] := bit(2);
      light[110] := bit(2);
      light[111] := bit(2);
      light[112] := bit(2);
      light[113] := bit(2);
      light[114] := bit(2);
      light[115] := bit(2);
      light[116] := bit(2);
      light[117] := bit(2);
      light[118] := bit(2);
      light[119] := bit(2);
      lc11_qx00 := 0;
      lc11_qx01 := 0;
      lc11_qx02 := 0;
      lc11_qx03 := 0;
      lc11_qx04 := 0;
      lc11_qx05 := 0;
      lc11_qx06 := 0;
      lc11_qx07 := 0;
      lc11_qx08 := 0;
      lc11_qx09 := 0;
    else
      if lc11_output_mode_00 > 0 or
         lc11_output_mode_01 > 0 or
         lc11_output_mode_02 > 0 or
         lc11_output_mode_03 > 0 or
         lc11_output_mode_04 > 0 or
         lc11_output_mode_05 > 0 or
         lc11_output_mode_06 > 0 or
         lc11_output_mode_07 > 0 or
         lc11_output_mode_08 > 0 or
         lc11_output_mode_09 > 0
      then
        lc11_output_mode_data := 0;
        lc11_output_mode_index := -1;
        lc11_output_mode_req := 1;
      end_if;
      input[110] := lc11_ix00;
      input[111] := lc11_ix01;
      input[112] := lc11_ix02;
      input[113] := lc11_ix03;
      input[114] := lc11_ix04;
      input[115] := lc11_ix05;
      input[116] := lc11_ix06;
      input[117] := lc11_ix07;
      input[118] := lc11_ix08;
      input[119] := lc11_ix09;
      lc11_qx00 := light[110];
      lc11_qx01 := light[111];
      lc11_qx02 := light[112];
      lc11_qx03 := light[113];
      lc11_qx04 := light[114];
      lc11_qx05 := light[115];
      lc11_qx06 := light[116];
      lc11_qx07 := light[117];
      lc11_qx08 := light[118];
      lc11_qx09 := light[119];
    end_if;
    
    if lc12_general_error then
      input[120] := bit(2);
      input[121] := bit(2);
      input[122] := bit(2);
      input[123] := bit(2);
      input[124] := bit(2);
      input[125] := bit(2);
      input[126] := bit(2);
      input[127] := bit(2);
      input[128] := bit(2);
      input[129] := bit(2);
      light[120] := bit(2);
      light[121] := bit(2);
      light[122] := bit(2);
      light[123] := bit(2);
      light[124] := bit(2);
      light[125] := bit(2);
      light[126] := bit(2);
      light[127] := bit(2);
      light[128] := bit(2);
      light[129] := bit(2);
      lc12_qx00 := 0;
      lc12_qx01 := 0;
      lc12_qx02 := 0;
      lc12_qx03 := 0;
      lc12_qx04 := 0;
      lc12_qx05 := 0;
      lc12_qx06 := 0;
      lc12_qx07 := 0;
      lc12_qx08 := 0;
      lc12_qx09 := 0;
    else
      if lc12_output_mode_00 > 0 or
         lc12_output_mode_01 > 0 or
         lc12_output_mode_02 > 0 or
         lc12_output_mode_03 > 0 or
         lc12_output_mode_04 > 0 or
         lc12_output_mode_05 > 0 or
         lc12_output_mode_06 > 0 or
         lc12_output_mode_07 > 0 or
         lc12_output_mode_08 > 0 or
         lc12_output_mode_09 > 0
      then
        lc12_output_mode_data := 0;
        lc12_output_mode_index := -1;
        lc12_output_mode_req := 1;
      end_if;
      input[120] := lc12_ix00;
      input[121] := lc12_ix01;
      input[122] := lc12_ix02;
      input[123] := lc12_ix03;
      input[124] := lc12_ix04;
      input[125] := lc12_ix05;
      input[126] := lc12_ix06;
      input[127] := lc12_ix07;
      input[128] := lc12_ix08;
      input[129] := lc12_ix09;
      lc12_qx00 := light[120];
      lc12_qx01 := light[121];
      lc12_qx02 := light[122];
      lc12_qx03 := light[123];
      lc12_qx04 := light[124];
      lc12_qx05 := light[125];
      lc12_qx06 := light[126];
      lc12_qx07 := light[127];
      lc12_qx08 := light[128];
      lc12_qx09 := light[129];
    end_if;
    
    if lc13_general_error then
      input[130] := bit(2);
      input[131] := bit(2);
      input[132] := bit(2);
      input[133] := bit(2);
      input[134] := bit(2);
      input[135] := bit(2);
      input[136] := bit(2);
      input[137] := bit(2);
      input[138] := bit(2);
      input[139] := bit(2);
      light[130] := bit(2);
      light[131] := bit(2);
      light[132] := bit(2);
      light[133] := bit(2);
      light[134] := bit(2);
      light[135] := bit(2);
      light[136] := bit(2);
      light[137] := bit(2);
      light[138] := bit(2);
      light[139] := bit(2);
      lc13_qx00 := 0;
      lc13_qx01 := 0;
      lc13_qx02 := 0;
      lc13_qx03 := 0;
      lc13_qx04 := 0;
      lc13_qx05 := 0;
      lc13_qx06 := 0;
      lc13_qx07 := 0;
      lc13_qx08 := 0;
      lc13_qx09 := 0;
    else
      if lc13_output_mode_00 > 0 or
         lc13_output_mode_01 > 0 or
         lc13_output_mode_02 > 0 or
         lc13_output_mode_03 > 0 or
         lc13_output_mode_04 > 0 or
         lc13_output_mode_05 > 0 or
         lc13_output_mode_06 > 0 or
         lc13_output_mode_07 > 0 or
         lc13_output_mode_08 > 0 or
         lc13_output_mode_09 > 0
      then
        lc13_output_mode_data := 0;
        lc13_output_mode_index := -1;
        lc13_output_mode_req := 1;
      end_if;
      input[130] := lc13_ix00;
      input[131] := lc13_ix01;
      input[132] := lc13_ix02;
      input[133] := lc13_ix03;
      input[134] := lc13_ix04;
      input[135] := lc13_ix05;
      input[136] := lc13_ix06;
      input[137] := lc13_ix07;
      input[138] := lc13_ix08;
      input[139] := lc13_ix09;
      lc13_qx00 := light[130];
      lc13_qx01 := light[131];
      lc13_qx02 := light[132];
      lc13_qx03 := light[133];
      lc13_qx04 := light[134];
      lc13_qx05 := light[135];
      lc13_qx06 := light[136];
      lc13_qx07 := light[137];
      lc13_qx08 := light[138];
      lc13_qx09 := light[139];
    end_if;
    
    if lc14_general_error then
      input[140] := bit(2);
      input[141] := bit(2);
      input[142] := bit(2);
      input[143] := bit(2);
      input[144] := bit(2);
      input[145] := bit(2);
      input[146] := bit(2);
      input[147] := bit(2);
      input[148] := bit(2);
      input[149] := bit(2);
      light[140] := bit(2);
      light[141] := bit(2);
      light[142] := bit(2);
      light[143] := bit(2);
      light[144] := bit(2);
      light[145] := bit(2);
      light[146] := bit(2);
      light[147] := bit(2);
      light[148] := bit(2);
      light[149] := bit(2);
      lc14_qx00 := 0;
      lc14_qx01 := 0;
      lc14_qx02 := 0;
      lc14_qx03 := 0;
      lc14_qx04 := 0;
      lc14_qx05 := 0;
      lc14_qx06 := 0;
      lc14_qx07 := 0;
      lc14_qx08 := 0;
      lc14_qx09 := 0;
    else
      if lc14_output_mode_00 > 0 or
         lc14_output_mode_01 > 0 or
         lc14_output_mode_02 > 0 or
         lc14_output_mode_03 > 0 or
         lc14_output_mode_04 > 0 or
         lc14_output_mode_05 > 0 or
         lc14_output_mode_06 > 0 or
         lc14_output_mode_07 > 0 or
         lc14_output_mode_08 > 0 or
         lc14_output_mode_09 > 0
      then
        lc14_output_mode_data := 0;
        lc14_output_mode_index := -1;
        lc14_output_mode_req := 1;
      end_if;
      input[140] := lc14_ix00;
      input[141] := lc14_ix01;
      input[142] := lc14_ix02;
      input[143] := lc14_ix03;
      input[144] := lc14_ix04;
      input[145] := lc14_ix05;
      input[146] := lc14_ix06;
      input[147] := lc14_ix07;
      input[148] := lc14_ix08;
      input[149] := lc14_ix09;
      lc14_qx00 := light[140];
      lc14_qx01 := light[141];
      lc14_qx02 := light[142];
      lc14_qx03 := light[143];
      lc14_qx04 := light[144];
      lc14_qx05 := light[145];
      lc14_qx06 := light[146];
      lc14_qx07 := light[147];
      lc14_qx08 := light[148];
      lc14_qx09 := light[149];
    end_if;
    
    if lc15_general_error then
      input[150] := bit(2);
      input[151] := bit(2);
      input[152] := bit(2);
      input[153] := bit(2);
      input[154] := bit(2);
      input[155] := bit(2);
      input[156] := bit(2);
      input[157] := bit(2);
      input[158] := bit(2);
      input[159] := bit(2);
      light[150] := bit(2);
      light[151] := bit(2);
      light[152] := bit(2);
      light[153] := bit(2);
      light[154] := bit(2);
      light[155] := bit(2);
      light[156] := bit(2);
      light[157] := bit(2);
      light[158] := bit(2);
      light[159] := bit(2);
      lc15_qx00 := 0;
      lc15_qx01 := 0;
      lc15_qx02 := 0;
      lc15_qx03 := 0;
      lc15_qx04 := 0;
      lc15_qx05 := 0;
      lc15_qx06 := 0;
      lc15_qx07 := 0;
      lc15_qx08 := 0;
      lc15_qx09 := 0;
    else
      if lc15_output_mode_00 > 0 or
         lc15_output_mode_01 > 0 or
         lc15_output_mode_02 > 0 or
         lc15_output_mode_03 > 0 or
         lc15_output_mode_04 > 0 or
         lc15_output_mode_05 > 0 or
         lc15_output_mode_06 > 0 or
         lc15_output_mode_07 > 0 or
         lc15_output_mode_08 > 0 or
         lc15_output_mode_09 > 0
      then
        lc15_output_mode_data := 0;
        lc15_output_mode_index := -1;
        lc15_output_mode_req := 1;
      end_if;
      input[150] := lc15_ix00;
      input[151] := lc15_ix01;
      input[152] := lc15_ix02;
      input[153] := lc15_ix03;
      input[154] := lc15_ix04;
      input[155] := lc15_ix05;
      input[156] := lc15_ix06;
      input[157] := lc15_ix07;
      input[158] := lc15_ix08;
      input[159] := lc15_ix09;
      lc15_qx00 := light[150];
      lc15_qx01 := light[151];
      lc15_qx02 := light[152];
      lc15_qx03 := light[153];
      lc15_qx04 := light[154];
      lc15_qx05 := light[155];
      lc15_qx06 := light[156];
      lc15_qx07 := light[157];
      lc15_qx08 := light[158];
      lc15_qx09 := light[159];
    end_if;
    
    if lc16_general_error then
      input[160] := bit(2);
      input[161] := bit(2);
      input[162] := bit(2);
      input[163] := bit(2);
      input[164] := bit(2);
      input[165] := bit(2);
      input[166] := bit(2);
      input[167] := bit(2);
      input[168] := bit(2);
      input[169] := bit(2);
      light[160] := bit(2);
      light[161] := bit(2);
      light[162] := bit(2);
      light[163] := bit(2);
      light[164] := bit(2);
      light[165] := bit(2);
      light[166] := bit(2);
      light[167] := bit(2);
      light[168] := bit(2);
      light[169] := bit(2);
      lc16_qx00 := 0;
      lc16_qx01 := 0;
      lc16_qx02 := 0;
      lc16_qx03 := 0;
      lc16_qx04 := 0;
      lc16_qx05 := 0;
      lc16_qx06 := 0;
      lc16_qx07 := 0;
      lc16_qx08 := 0;
      lc16_qx09 := 0;
    else
      if lc16_output_mode_00 > 0 or
         lc16_output_mode_01 > 0 or
         lc16_output_mode_02 > 0 or
         lc16_output_mode_03 > 0 or
         lc16_output_mode_04 > 0 or
         lc16_output_mode_05 > 0 or
         lc16_output_mode_06 > 0 or
         lc16_output_mode_07 > 0 or
         lc16_output_mode_08 > 0 or
         lc16_output_mode_09 > 0
      then
        lc16_output_mode_data := 0;
        lc16_output_mode_index := -1;
        lc16_output_mode_req := 1;
      end_if;
      input[160] := lc16_ix00;
      input[161] := lc16_ix01;
      input[162] := lc16_ix02;
      input[163] := lc16_ix03;
      input[164] := lc16_ix04;
      input[165] := lc16_ix05;
      input[166] := lc16_ix06;
      input[167] := lc16_ix07;
      input[168] := lc16_ix08;
      input[169] := lc16_ix09;
      lc16_qx00 := light[160];
      lc16_qx01 := light[161];
      lc16_qx02 := light[162];
      lc16_qx03 := light[163];
      lc16_qx04 := light[164];
      lc16_qx05 := light[165];
      lc16_qx06 := light[166];
      lc16_qx07 := light[167];
      lc16_qx08 := light[168];
      lc16_qx09 := light[169];
    end_if;
    
    if lc17_general_error then
      input[170] := bit(2);
      input[171] := bit(2);
      input[172] := bit(2);
      input[173] := bit(2);
      input[174] := bit(2);
      input[175] := bit(2);
      input[176] := bit(2);
      input[177] := bit(2);
      input[178] := bit(2);
      input[179] := bit(2);
      light[170] := bit(2);
      light[171] := bit(2);
      light[172] := bit(2);
      light[173] := bit(2);
      light[174] := bit(2);
      light[175] := bit(2);
      light[176] := bit(2);
      light[177] := bit(2);
      light[178] := bit(2);
      light[179] := bit(2);
      lc17_qx00 := 0;
      lc17_qx01 := 0;
      lc17_qx02 := 0;
      lc17_qx03 := 0;
      lc17_qx04 := 0;
      lc17_qx05 := 0;
      lc17_qx06 := 0;
      lc17_qx07 := 0;
      lc17_qx08 := 0;
      lc17_qx09 := 0;
    else
      if lc17_output_mode_00 > 0 or
         lc17_output_mode_01 > 0 or
         lc17_output_mode_02 > 0 or
         lc17_output_mode_03 > 0 or
         lc17_output_mode_04 > 0 or
         lc17_output_mode_05 > 0 or
         lc17_output_mode_06 > 0 or
         lc17_output_mode_07 > 0 or
         lc17_output_mode_08 > 0 or
         lc17_output_mode_09 > 0
      then
        lc17_output_mode_data := 0;
        lc17_output_mode_index := -1;
        lc17_output_mode_req := 1;
      end_if;
      input[170] := lc17_ix00;
      input[171] := lc17_ix01;
      input[172] := lc17_ix02;
      input[173] := lc17_ix03;
      input[174] := lc17_ix04;
      input[175] := lc17_ix05;
      input[176] := lc17_ix06;
      input[177] := lc17_ix07;
      input[178] := lc17_ix08;
      input[179] := lc17_ix09;
      lc17_qx00 := light[170];
      lc17_qx01 := light[171];
      lc17_qx02 := light[172];
      lc17_qx03 := light[173];
      lc17_qx04 := light[174];
      lc17_qx05 := light[175];
      lc17_qx06 := light[176];
      lc17_qx07 := light[177];
      lc17_qx08 := light[178];
      lc17_qx09 := light[179];
    end_if;
    
    if lc18_general_error then
      input[180] := bit(2);
      input[181] := bit(2);
      input[182] := bit(2);
      input[183] := bit(2);
      input[184] := bit(2);
      input[185] := bit(2);
      input[186] := bit(2);
      input[187] := bit(2);
      input[188] := bit(2);
      input[189] := bit(2);
      light[180] := bit(2);
      light[181] := bit(2);
      light[182] := bit(2);
      light[183] := bit(2);
      light[184] := bit(2);
      light[185] := bit(2);
      light[186] := bit(2);
      light[187] := bit(2);
      light[188] := bit(2);
      light[189] := bit(2);
      lc18_qx00 := 0;
      lc18_qx01 := 0;
      lc18_qx02 := 0;
      lc18_qx03 := 0;
      lc18_qx04 := 0;
      lc18_qx05 := 0;
      lc18_qx06 := 0;
      lc18_qx07 := 0;
      lc18_qx08 := 0;
      lc18_qx09 := 0;
    else
      if lc18_output_mode_00 > 0 or
         lc18_output_mode_01 > 0 or
         lc18_output_mode_02 > 0 or
         lc18_output_mode_03 > 0 or
         lc18_output_mode_04 > 0 or
         lc18_output_mode_05 > 0 or
         lc18_output_mode_06 > 0 or
         lc18_output_mode_07 > 0 or
         lc18_output_mode_08 > 0 or
         lc18_output_mode_09 > 0
      then
        lc18_output_mode_data := 0;
        lc18_output_mode_index := -1;
        lc18_output_mode_req := 1;
      end_if;
      input[180] := lc18_ix00;
      input[181] := lc18_ix01;
      input[182] := lc18_ix02;
      input[183] := lc18_ix03;
      input[184] := lc18_ix04;
      input[185] := lc18_ix05;
      input[186] := lc18_ix06;
      input[187] := lc18_ix07;
      input[188] := lc18_ix08;
      input[189] := lc18_ix09;
      lc18_qx00 := light[180];
      lc18_qx01 := light[181];
      lc18_qx02 := light[182];
      lc18_qx03 := light[183];
      lc18_qx04 := light[184];
      lc18_qx05 := light[185];
      lc18_qx06 := light[186];
      lc18_qx07 := light[187];
      lc18_qx08 := light[188];
      lc18_qx09 := light[189];
    end_if;
    
    if lc19_general_error then
      input[190] := bit(2);
      input[191] := bit(2);
      input[192] := bit(2);
      input[193] := bit(2);
      input[194] := bit(2);
      input[195] := bit(2);
      input[196] := bit(2);
      input[197] := bit(2);
      input[198] := bit(2);
      input[199] := bit(2);
      light[190] := bit(2);
      light[191] := bit(2);
      light[192] := bit(2);
      light[193] := bit(2);
      light[194] := bit(2);
      light[195] := bit(2);
      light[196] := bit(2);
      light[197] := bit(2);
      light[198] := bit(2);
      light[199] := bit(2);
      lc19_qx00 := 0;
      lc19_qx01 := 0;
      lc19_qx02 := 0;
      lc19_qx03 := 0;
      lc19_qx04 := 0;
      lc19_qx05 := 0;
      lc19_qx06 := 0;
      lc19_qx07 := 0;
      lc19_qx08 := 0;
      lc19_qx09 := 0;
    else
      if lc19_output_mode_00 > 0 or
         lc19_output_mode_01 > 0 or
         lc19_output_mode_02 > 0 or
         lc19_output_mode_03 > 0 or
         lc19_output_mode_04 > 0 or
         lc19_output_mode_05 > 0 or
         lc19_output_mode_06 > 0 or
         lc19_output_mode_07 > 0 or
         lc19_output_mode_08 > 0 or
         lc19_output_mode_09 > 0
      then
        lc19_output_mode_data := 0;
        lc19_output_mode_index := -1;
        lc19_output_mode_req := 1;
      end_if;
      input[190] := lc19_ix00;
      input[191] := lc19_ix01;
      input[192] := lc19_ix02;
      input[193] := lc19_ix03;
      input[194] := lc19_ix04;
      input[195] := lc19_ix05;
      input[196] := lc19_ix06;
      input[197] := lc19_ix07;
      input[198] := lc19_ix08;
      input[199] := lc19_ix09;
      lc19_qx00 := light[190];
      lc19_qx01 := light[191];
      lc19_qx02 := light[192];
      lc19_qx03 := light[193];
      lc19_qx04 := light[194];
      lc19_qx05 := light[195];
      lc19_qx06 := light[196];
      lc19_qx07 := light[197];
      lc19_qx08 := light[198];
      lc19_qx09 := light[199];
    end_if;
    
  end;
  function f_algorithms:int; language 'Structured Text';
    function f_input_mux:void; language 'Structured Text';
    begin
      
      for i := 0 to 199 do
        light_mode[i] := 0;
        light_toggle[i] := 0;
        light_extend[i] := 0;
        light_inverse[i] := 1;
      end_for;
      for i := 0 to 49 do
        scene_mode[i] := 0;
        scene_toggle[i] := 0;
        scene_extend[i] := 0;
        scene_inverse[i] := 1;
      end_for;
      
      for i := 0 to 199 do
      
        if (input_mux[i] / 10) % 10 = 1 then     // light mux
          case input_mux[i] % 10 of
            1 : // button
              light_mode[input_mux[i] / 100] := light_mode[input_mux[i] / 100] or 1;
              if (input_low_light[i] and low_light_status) or
                 !input_low_light[i]
              then
                light_toggle[input_mux[i]/100] := light_toggle[input_mux[i]/100] or input[i];
              end_if;
            2 : // motion
              light_mode[input_mux[i] / 100] := light_mode[input_mux[i] / 100] or 2;
              if (input_low_light[i] and low_light_status) or
                 !input_low_light[i]
              then
                light_extend[input_mux[i]/100] := light_extend[input_mux[i]/100] or input[i];
              end_if;
            3 : // door
              light_mode[input_mux[i] / 100] := light_mode[input_mux[i] / 100] or 4;
              if (input_low_light[i] and low_light_status) or
                 !input_low_light[i]
              then
                light_inverse[input_mux[i]/100] := light_inverse[input_mux[i]/100] and input[i];
              end_if;
          end_case;
        elsif (input_mux[i] / 10) % 10 = 2 then  // scene mux
          case input_mux[i] % 10 of
            1 : // button
              scene_mode[input_mux[i] / 100] := scene_mode[input_mux[i] / 100] or 1;
              if (input_low_light[i] and low_light_status) or
                 !input_low_light[i]
              then
                scene_toggle[input_mux[i]/100] := scene_toggle[input_mux[i]/100] or input[i];
              end_if;
            2 : // motion
              scene_mode[input_mux[i] / 100] := scene_mode[input_mux[i] / 100] or 2;
              if (input_low_light[i] and low_light_status) or
                 !input_low_light[i]
              then
                scene_extend[input_mux[i]/100] := scene_extend[input_mux[i]/100] or input[i];
              end_if;
            3 : // door
              scene_mode[input_mux[i] / 100] := scene_mode[input_mux[i] / 100] or 4;
              if (input_low_light[i] and low_light_status) or
                 !input_low_light[i]
              then
                scene_inverse[input_mux[i]/100] := scene_inverse[input_mux[i]/100] and input[i];
              end_if;
          end_case;
        end_if;
      
      end_for;
      
    end;
    function f_timetable:int; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      tt_scene: int;
      tt_scene_old: int; default=-2;
    var_end;

    var
      weekday: int;
    var_end;

      function min_max(mm_val,mm_min,mm_max:int):int; language 'Structured Text';
      begin
        /*
        
          limit integer
        
        */
        
        if mm_val = 0 then
          result := 0;
        elsif mm_val > mm_max then
          result := mm_max;
        elsif mm_val < mm_min then
          result := mm_min;
        else
          result := mm_val;
        end_if;
      end;
    begin
      
      // get scene from timetable
      weekday := rtc_weekday - 1;
      if weekday < 0 then
        weekday := 6;
      end_if;
      
      tt_scene := timetable_scene[48 * weekday + 2 * rtc_hour + rtc_min / 30]; // index = 0..335
      tt_scene := min_max(tt_scene, 0, 49);
      
      if tt_scene_old <> -2 and
         tt_scene >= 0 and
         tt_scene <> tt_scene_old
      then
        scene_cmd := 100 + tt_scene;
      end_if;
      
      tt_scene_old := tt_scene;
    end;
    function f_low_light:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      hi: ARRAY[0..3] OF int;
    var_end;

    var
      eot: int;
      di: int;
      df: int;
      hat: int;
    var_end;

    begin
      // calculate daylight status (light or dark) based on calculated
      // sunrise and sunset times with optional user offset
      // calculation is based on latitude, longitude, time zone and RTC
      // latitude is valid in range -65 to +65 (positive=north, negative=south)
      // longitude is valid in range -180 to +180 (positive=east, negative=west)
      // precision is +/-15 minutes at the north and south extremes, +/-5 minutes otherwise
      
      // calculate equation of time
      
      di:=day_of_year/28;
      df:=day_of_year mod 28;
      case di of
       0: eot:=(-11*df)/28-3;
       1: eot:=df/28-14;
       2: eot:=(7*df)/28-13;
       3: eot:=(8*df)/28-6;
       4: eot:=(2*df)/28+2;
       5: eot:=(-5*df)/28+4;
       6: eot:=(-5*df)/28-1;
       7: eot:=-6;
       8: eot:=(9*df)/28-6;
       9: eot:=(10*df)/28+3;
       10:eot:=(4*df)/28+13;
       11:eot:=(-6*df)/28+17;
       12:eot:=(-14*df)/28+11;
       13:eot:=(-11*df)/28-3;
      else
        eot:=0;
      end_case;
      
      // calculate hour angle
      
      if (low_light_latitude>=0) and (low_light_latitude<45) then
        hi[0]:=(-102*low_light_latitude)/45+3;
        hi[1]:=(-91*low_light_latitude)/45+3;
        hi[2]:=(96*low_light_latitude)/45+3;
        hi[3]:=(107*low_light_latitude)/45+3;
      elsif (low_light_latitude>=45) and (low_light_latitude<60) then
        hi[0]:=(-86*(low_light_latitude-45))/15-99;
        hi[1]:=(-75*(low_light_latitude-45))/15-88;
        hi[2]:=(81*(low_light_latitude-45))/15+99;
        hi[3]:=(100*(low_light_latitude-45))/15+110;
      elsif low_light_latitude>=60 then
        hi[0]:=(-75*(low_light_latitude-60))/5-185;
        hi[1]:=(-47*(low_light_latitude-60))/5-163;
        hi[2]:=(60*(low_light_latitude-60))/5+180;
        hi[3]:=(95*(low_light_latitude-60))/5+210;
      elsif (low_light_latitude>=-45) and (low_light_latitude<0) then
        hi[0]:=(-107*(low_light_latitude+45))/45+110;
        hi[1]:=(-95*(low_light_latitude+45))/45+98;
        hi[2]:=(91*(low_light_latitude+45))/45-88;
        hi[3]:=(102*(low_light_latitude+45))/45-99;
      elsif (low_light_latitude>=-60) and (low_light_latitude<-45) then
        hi[0]:=(-100*(low_light_latitude+60))/15+210;
        hi[1]:=(-82*(low_light_latitude+60))/15+180;
        hi[2]:=(74*(low_light_latitude+60))/15-162;
        hi[3]:=(86*(low_light_latitude+60))/15-185;
      else // latitude<-60
        hi[0]:=(-97*(low_light_latitude+65))/5+307;
        hi[1]:=(-56*(low_light_latitude+65))/5+236;
        hi[2]:=(53*(low_light_latitude+65))/5-215;
        hi[3]:=(70*(low_light_latitude+65))/5-255;
      end_if;
      
      if (day_of_year<14) or (day_of_year>=354) then
        hat:=(hi[1]-hi[0])*((day_of_year+12) mod 366)/26+hi[0];
      elsif (day_of_year>=12) and (day_of_year<146) then
        hat:=int((hi[2]-hi[1])*(long(day_of_year)-14)/132)+hi[1];
      elsif (day_of_year>=146) and (day_of_year<172) then
        hat:=(hi[3]-hi[2])*(day_of_year-146)/26+hi[2];
      elsif (day_of_year>=172) and (day_of_year<198) then
        hat:=(hi[2]-hi[3])*(day_of_year-172)/26+hi[3];
      elsif (day_of_year>=198) and (day_of_year<328) then
        hat:=int(((hi[1]-hi[2])*(long(day_of_year)-198))/130)+hi[2];
      elsif (day_of_year>=328) and (day_of_year<354) then
        hat:=(hi[0]-hi[1])*(day_of_year-328)/26+hi[1];
      end_if;
      
      // calculate sunrise and sunset time, corected by local offset [minutes]
      
      sunrise:=360+low_light_time_zone*60-(low_light_longitude*4+eot+hat)+low_light_local_offset;
      sunset:=1080+low_light_time_zone*60-(low_light_longitude*4+eot-hat)-low_light_local_offset;
      
      sunrise_hour:=sunrise/60; // used to show on mini scada
      sunrise_min:=sunrise%60;
      sunset_hour:=sunset/60;
      sunset_min:=sunset%60;
      
      // set low light indicator
      
      if low_light_counter > 0 then
        low_light_counter := low_light_counter - fp(clock_1s);
      else
        light_sensor_value:=cybro_iw12 / 100;
        low_light_status := (minute_of_day < sunrise) or (minute_of_day > sunset) or (light_sensor_enable and (light_sensor_value < light_sensor_threshold));
      end_if;
      
      if fp(low_light_status) and
         scene_sunset >= 0
      then
        scene_cmd := 100 + scene_sunset;
      end_if;
      
      if fn(low_light_status) and
         scene_sunrise >= 0
      then
        scene_cmd := 100 + scene_sunrise;
      end_if;
    end;
    function f_light:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      light_toggle_old: ARRAY[0..199] OF bool;
      light_toggle_time: ARRAY[0..199] OF int;
      light_toggle_ev: ARRAY[0..199] OF int;
      light_long: ARRAY[0..199] OF bool;
      light_timer: ARRAY[0..199] OF long;
      light_extend_old: ARRAY[0..199] OF bool;
      light_inverse_old: ARRAY[0..199] OF bool;
      ready_light_state: ARRAY[0..199] OF int;
      ready_light: ARRAY[0..199] OF bool;
      ready_light_old: ARRAY[0..199] OF bool;
      light_old: ARRAY[0..199] OF bool;
    var_end;

    begin
      
      for i := 0 to 199 do
      
        // button events
        if light_toggle[i] then
          // long press
          if light_toggle_time[i] >= 500 then
            light_toggle_ev[i] := EV_LP;
          // rising edge
          elsif light_toggle_time[i] = 0 then
            light_toggle_ev[i] := EV_FP;
          // no event
          else
            light_toggle_ev[i] := 0;
          end_if;
          // input time
          if light_toggle_time[i] < 20000 then
            light_toggle_time[i] := light_toggle_time[i] + scan_time;
          end_if;
        else
          // falling edge
          if light_toggle_time[i] > 0 and
             light_toggle_time[i] < 500    // disable after LP
          then
            light_toggle_ev[i] := EV_FN;
          else
            light_toggle_ev[i] := 0;
          end_if;
          light_toggle_time[i] := 0;
        end_if;
      
        // button -> toggle
        if light_long_tout[i] > 0 then
          // toggle on fn
          if light_toggle_ev[i] = EV_FN then
            light[i] := !light[i];
          end_if;
          // long press
          if light_toggle_ev[i] = EV_LP then
            light[i] := 1;
            light_long[i] := 1;
          end_if;
        else
          // toggle on fp
          if light_toggle_ev[i] = EV_FP then
            light[i] := !light[i];
          end_if;
        end_if;
      
        if !light[i] then
          light_long[i] := 0;
        end_if;
      
        if light_mode[i] < 6 then
      
          // motion -> on
          if light_extend[i] and !light_extend_old[i]
          then
            light[i] := 1;
          end_if;
          light_extend_old[i] := light_extend[i];
          // timer extend
          if light_extend[i] and light[i]
          then
            light_timer[i] := 0;
          end_if;
      
          // door -> inverse
          if light_inverse[i] and !light_inverse_old[i] then // fp -> off
            light[i] := 0;
          elsif !light_inverse[i] and light_inverse_old[i] then // fn -> on
            light[i] := 1;
          end_if;
          light_inverse_old[i] := light_inverse[i];
      
          // timeout
          if light[i] and light_long[i] and !light_extend[i] then
            light_timer[i] := light_timer[i] + scan_time;
            if light_timer[i] >= long(light_long_tout[i]) * 60000 then
              light[i] := 0;
            end_if;
          elsif light[i] and light_tout[i] > 0 and !light_extend[i] then
            light_timer[i] := light_timer[i] + scan_time;
            if light_timer[i] >= long(light_tout[i]) * 60000 then
              light[i] := 0;
            end_if;
          else
            light_timer[i] := 0;
          end_if;
      
        else // ready light
      
          // presence state machine
          case ready_light_state[i] of
      
            0: // empty
              ready_light[i] := 0;
              if !light_inverse[i] and light_inverse_old[i] then  // door opened
                ready_light_state[i] := 2;                   // limited presence
                light_timer[i] := 0;
              end_if;
              if light_extend[i] or                    // motion sensor activated
                 (light[i] and !light_old[i])         // light manual on
              then
                if !light_inverse[i] then              // door
                  ready_light_state[i] := 2;       // door opened -> limited presence
                  light_timer[i] := 0;
                else
                  ready_light_state[i] := 1;       // door closed -> presence
                  light_timer[i] := 0;
                end_if;
              end_if;
      
            1: // presence
              ready_light[i] := 1;
              if !light_inverse[i] and light_inverse_old[i] then    // door opened
                ready_light_state[i] := 2;                     // door opened -> limited presence
                light_timer[i] := 0;
              end_if;
      
            2: // limited presence
              ready_light[i] := 1;
              // timeout
              if light_extend[i] then
                light_timer[i] := 0;
              else
                light_timer[i] := light_timer[i] + scan_time;
              end_if;
              // transitions
              if light_timer[i] >= long(light_tout[i]) * 60000 or       // timeout
                 (!light[i] and light_old[i])
              then
                ready_light_state[i] := 0;     // empty
                light_timer[i] := 0;
              end_if;
              if light_inverse[i] and !light_inverse_old[i] then    // door closed
                ready_light_state[i] := 3;     // unknown
                light_timer[i] := 0;
              end_if;
      
            3: // unknown
              ready_light[i] := 1;
              light_timer[i] := light_timer[i] + scan_time;
              if light_timer[i] >= long(light_short_tout[i]) * 1000 then   // timeout
                if light_extend[i] then
                  ready_light_state[i] := 1; // occupied
                  light_timer[i] := 0;
                else
                  ready_light_state[i] := 0; // empty
                  light_timer[i] := 0;
                end_if;
              end_if;
              if (!light[i] and light_old[i]) then  // manual off
                ready_light_state[i] := 0; // empty
                light_timer[i] := 0;
              end_if;
              if light_extend[i] and !light_extend_old[i] then  // fp sensor
                ready_light_state[i] := 1; // occupied
                light_timer[i] := 0;
              end_if;
      
            // illegal state
            else
              ready_light[i] := 0;
              ready_light_state[i] := 0; // empty
              light_timer[i] := 0;
          end_case;
      
          // toggle light
          if ready_light[i] and !ready_light_old[i] then
            light[i] := 1;
          end_if;
          if !ready_light[i] and ready_light_old[i] then
            light[i] := 0;
          end_if;
          ready_light_old[i] := ready_light[i];
      
          light_inverse_old[i] := light_inverse[i];
          light_extend_old[i] := light_extend[i];
          light_old[i] := light[i];
      
        end_if;
      
      end_for;
    end;
    function f_scene:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      si: int;
      scene_toggle_old: ARRAY[0..49] OF bool;
      scene_toggle_time: ARRAY[0..49] OF int;
      scene_toggle_ev: ARRAY[0..49] OF int;
      scene_long: ARRAY[0..49] OF bool;
      scene_timer: ARRAY[0..49] OF long;
      scene_extend_old: ARRAY[0..49] OF bool;
      scene_inverse_old: ARRAY[0..49] OF bool;
      ready_scene_state: ARRAY[0..49] OF int;
      ready_scene: ARRAY[0..49] OF bool;
      ready_scene_old: ARRAY[0..49] OF bool;
      scene_old: ARRAY[0..49] OF bool;
    var_end;

    var
      scene_a: bool;
      scene_e: bool;
    var_end;

    begin
      
      for i := 0 to 49 do
      
        // button events
        if scene_toggle[i] then
          // long press
          if scene_toggle_time[i] >= 500 then
            scene_toggle_ev[i] := EV_LP;
          // rising edge
          elsif scene_toggle_time[i] = 0 then
            scene_toggle_ev[i] := EV_FP;
          // no event
          else
            scene_toggle_ev[i] := 0;
          end_if;
          // input time
          if scene_toggle_time[i] < 20000 then
            scene_toggle_time[i] := scene_toggle_time[i] + scan_time;
          end_if;
        else
          // falling edge
          if scene_toggle_time[i] > 0 and
             scene_toggle_time[i] < 500    // disable after LP
          then
            scene_toggle_ev[i] := EV_FN;
          else
            scene_toggle_ev[i] := 0;
          end_if;
          scene_toggle_time[i] := 0;
        end_if;
      
        // button -> toggle
        if scene_long_tout[i] > 0 then
          // toggle on fn
          if scene_toggle_ev[i] = EV_FN then
            scene_cmd := i;
          end_if;
          // long press
          if scene_toggle_ev[i] = EV_LP then
            scene_cmd := 100 + i;
            scene_long[i] := 1;
          end_if;
        else
          // toggle on fp
          if scene_toggle_ev[i] = EV_FP then
            scene_cmd := i;
          end_if;
        end_if;
      
        if !scene[i] then
          scene_long[i] := 0;
        end_if;
      
        if scene_mode[i] < 6 then
      
          // motion -> on
          if scene_extend[i] and !scene_extend_old[i]
          then
            scene_cmd := 100 + i;
          end_if;
          scene_extend_old[i] := scene_extend[i];
          // timer extend
          if scene_extend[i] and scene[i]
          then
            scene_timer[i] := 0;
          end_if;
      
          // door -> inverse
          if scene_inverse[i] and !scene_inverse_old[i] then // fp -> off
            scene_cmd := 50 + i;
          elsif !scene_inverse[i] and scene_inverse_old[i] then // fn -> on
            scene_cmd := 100 + i;
          end_if;
          scene_inverse_old[i] := scene_inverse[i];
      
          // timeout
          if scene[i] and scene_long[i] and !scene_extend[i] then
            scene_timer[i] := scene_timer[i] + scan_time;
            if scene_timer[i] >= long(scene_long_tout[i]) * 60000 then
              scene_cmd := 50 + i;
            end_if;
          elsif scene[i] and scene_tout[i] > 0 and !scene_extend[i] then
            scene_timer[i] := scene_timer[i] + scan_time;
            if scene_timer[i] >= long(scene_tout[i]) * 60000 then
              scene_cmd := 50 + i;
            end_if;
          else
            scene_timer[i] := 0;
          end_if;
      
        else // ready scene
      
          // presence state machine
          case ready_scene_state[i] of
      
            0: // empty
              ready_scene[i] := 0;
              if !scene_inverse[i] and scene_inverse_old[i] then  // door opened
                ready_scene_state[i] := 2;                   // limited presence
                scene_timer[i] := 0;
              end_if;
              if scene_extend[i] or                    // motion sensor activated
                 (scene[i] and !scene_old[i])         // scene manual on
              then
                if !scene_inverse[i] then              // door
                  ready_scene_state[i] := 2;       // door opened -> limited presence
                  scene_timer[i] := 0;
                else
                  ready_scene_state[i] := 1;       // door closed -> presence
                  scene_timer[i] := 0;
                end_if;
              end_if;
      
            1: // presence
              ready_scene[i] := 1;
              if !scene_inverse[i] and scene_inverse_old[i] then    // door opened
                ready_scene_state[i] := 2;                     // door opened -> limited presence
                scene_timer[i] := 0;
              end_if;
      
            2: // limited presence
              ready_scene[i] := 1;
              // timeout
              if scene_extend[i] then
                scene_timer[i] := 0;
              else
                scene_timer[i] := scene_timer[i] + scan_time;
              end_if;
              // transitions
              if scene_timer[i] >= long(scene_tout[i]) * 60000 or       // timeout
                 (!scene[i] and scene_old[i])
              then
                ready_scene_state[i] := 0;     // empty
                scene_timer[i] := 0;
              end_if;
              if scene_inverse[i] and !scene_inverse_old[i] then    // door closed
                ready_scene_state[i] := 3;     // unknown
                scene_timer[i] := 0;
              end_if;
      
            3: // unknown
              ready_scene[i] := 1;
              scene_timer[i] := scene_timer[i] + scan_time;
              if scene_timer[i] >= long(scene_short_tout[i]) * 1000 then   // timeout
                if scene_extend[i] then
                  ready_scene_state[i] := 1; // occupied
                  scene_timer[i] := 0;
                else
                  ready_scene_state[i] := 0; // empty
                  scene_timer[i] := 0;
                end_if;
              end_if;
              if (!scene[i] and scene_old[i]) then  // manual off
                ready_scene_state[i] := 0; // empty
                scene_timer[i] := 0;
              end_if;
              if scene_extend[i] and !scene_extend_old[i] then  // fp sensor
                ready_scene_state[i] := 1; // occupied
                scene_timer[i] := 0;
              end_if;
      
            // illegal state
            else
              ready_scene[i] := 0;
              ready_scene_state[i] := 0; // empty
              scene_timer[i] := 0;
          end_case;
      
          // toggle scene
          if ready_scene[i] and !ready_scene_old[i] then
            scene_cmd := 100 + i;
          end_if;
          if !ready_scene[i] and ready_scene_old[i] then
            scene_cmd := 50 + i;
          end_if;
          ready_scene_old[i] := ready_scene[i];
      
          scene_inverse_old[i] := scene_inverse[i];
          scene_extend_old[i] := scene_extend[i];
          scene_old[i] := scene[i];
      
        end_if;
      
      end_for;
      
      test[0] := scene_cmd;
      
      if scene_cmd >= 0 and scene_cmd <= 49 then // toggle
        if !scene[scene_cmd] then
          for i := 0 to 199 do
            if scene_mem[scene_cmd * 200 + i] >= 0 then
              light[i] := bit(scene_mem[scene_cmd * 200 + i]);
            end_if;
          end_for;
        else
          for i := 0 to 199 do
            if scene_mem[scene_cmd * 200 + i] >= 0 then
              light[i] := 0;
            end_if;
          end_for;
        end_if;
      elsif scene_cmd >= 50 and scene_cmd <= 99 then // off
        for i := 0 to 199 do
          if scene_mem[(scene_cmd - 50) * 200 + i] >= 0 then
            light[i] := 0;
          end_if;
        end_for;
      elsif scene_cmd >= 100 and scene_cmd <= 149 then // on
        for i := 0 to 199 do
          if scene_mem[(scene_cmd - 100) * 200 + i] >= 0 then
            light[i] := bit(scene_mem[(scene_cmd-100) * 200 + i]);
          end_if;
        end_for;
      end_if;
      scene_cmd := -1;
      
      scene_a := 1;
      scene_e := 0;
      for i := 0 to 199 do
        if light[i] <> 2 and
           scene_mem[si * 200 + i] <> -1 and
           light[i] <> scene_mem[si * 200 + i]
        then
          scene_a := 0;
        end_if;
        if scene_mem[si * 200 + i] <> -1 then
          scene_e := 1;
        end_if;
      end_for;
      if scene_e then
        scene[si] := scene_a;
      else
        scene[si] := bit(2);
      end_if;
      
      si := (si + 1) % 50;
    end;
    function f_configure:void; language 'Structured Text';
    // AllocGroupList="User Variables"
    var static
      input_selected_old: int;
      light_selected_old: int;
      scene_selected_old: int;
      mscada_page_old: int;
      mscada_timer: int;
    var_end;

    var
      si: int;
      input_type: int;
      clear_select: bool;
    var_end;

      function min_max(val,v_min,v_max:int):int; language 'Structured Text';
      begin
        
        // function min_max(val, min, max:int):int;
        //
        // limit val to min - max
        
        if val > v_max then
          result := v_max;
        elsif val < v_min then
          result := v_min;
        else
          result := val;
        end_if;
      end;
    begin
      
      // ****************************************************************************
      // select input / scene / light
      // ****************************************************************************
      
      clear_select := 0;
      
      if mscada_ping then
        mscada_timer := 10000;
      end_if;
      mscada_ping := 0;
      
      if mscada_timer > 0 then
        mscada_timer := mscada_timer - scan_time;
      else
        mscada_timer := 0;
      end_if;
      mscada_active := mscada_timer > 0;
      
      if mscada_page <> mscada_page_old or
         fn(mscada_active)
      then
        clear_select := 1;
        input_selected := -1;
        scene_selected := -1;
        light_selected := -1;
        timetable_selected := -1;
      end_if;
      mscada_page_old := mscada_page;
      
      // select input
      
      if scene_selected = -1 and
         light_selected = -1 and
         timetable_selected = -1 and
         !clear_select
      then
        for i := 0 to 199 do
          if input_select[i] and int(input[i]) <> 2 then
            if input_selected = i then
              input_selected := -1;
              clear_select := 1;
            else
              input_selected := i;
            end_if;
          end_if;
          input_select[i] := 0;
        end_for;
      end_if;
      
      // select scene
      
      if input_selected = -1 and
         light_selected = -1 and
         timetable_selected = -1 and
         !clear_select
      then
        for i := 0 to 49 do
          if scene_select[i] then
            if scene_selected = i then
              scene_selected := -1;
              clear_select := 1;
            else
              scene_selected := i;
            end_if;
          end_if;
          scene_select[i] := 0;
        end_for;
      end_if;
      
      // select light
      
      if input_selected = -1 and
         scene_selected = -1 and
         timetable_selected = -1 and
         !clear_select
      then
        for i := 0 to 199 do
          if light_select[i] and int(light[i]) <> 2 then
            if light_selected = i then
              light_selected := -1;
              clear_select := 1;
            else
              light_selected := i;
            end_if;
          end_if;
          light_select[i] := 0;
        end_for;
      end_if;
      
      // select timetable
      
      if input_selected = -1 and
         light_selected = -1 and
         scene_selected = -1 and
         !clear_select
      then
        for i := 0 to 335 do
          if timetable_select[i] then
            if timetable_selected = i then
              timetable_selected := -1;
              clear_select := 1;
            else
              timetable_selected := i;
            end_if;
          end_if;
          timetable_select[i] := 0;
        end_for;
      end_if;
      
      // ****************************************************************************
      // manage input / scene / light settings
      // ****************************************************************************
      
      // clear all
      input_count := 0;
      scene_count := 0;
      light_count := 0;
      timetable_count := 0;
      for i := 0 to 49 do
        input_mark[i] := 0;
        scene_mark[i] := 0;
        light_mark[i] := 0;
        timetable_mark[i] := 0;
        if clear_select then
          input_select[i] := 0;
          scene_select[i] := 0;
          light_select[i] := 0;
          timetable_select[i] := 0;
        end_if;
        input_count := input_count + input_select[i];
        light_count := light_count + light_select[i];
        scene_count := scene_count + scene_select[i];
        timetable_count := timetable_count + timetable_select[i];
      end_for;
      for i := 50 to 199 do
        input_mark[i] := 0;
        light_mark[i] := 0;
        timetable_mark[i] := 0;
        if clear_select then
          input_select[i] := 0;
          light_select[i] := 0;
          timetable_select[i] := 0;
        end_if;
        input_count := input_count + input_select[i];
        light_count := light_count + light_select[i];
        timetable_count := timetable_count + timetable_select[i];
      end_for;
      for i := 200 to 335 do
        timetable_mark[i] := 0;
        if clear_select then
          timetable_select[i] := 0;
        end_if;
        timetable_count := timetable_count + timetable_select[i];
      end_for;
      select_count := input_count + scene_count + light_count;
      
      clear_select := 0;
      
      // input selected
      
      si := input_selected;
      if input_selected >= 0 then
        // mark light
        input_mark[si] := 2;
        // mark scene / light
        if (input_mux[si] / 10) % 10 = 1 then
          light_mark[input_mux[si] / 100] := 1;
        elsif (input_mux[si] / 10) % 10 = 2 then
          scene_mark[input_mux[si] / 100] := 1;
        end_if;
      end_if;
      input_selected_old := input_selected;
      
      // scene selected
      
      si := scene_selected;
      if scene_selected <> scene_selected_old then
        selected_scene_tout := scene_tout[si];
        selected_scene_long_tout := scene_long_tout[si];
      elsif scene_selected >= 0 then
        scene_mark[si] := 2;
        if mscada_page = 0 then // inputs-scenes-lights page
          for i := 0 to 199 do
            // mark input
            if ((input_mux[i] / 10) % 10 = 2) and (input_mux[i] / 100 = scene_selected) then
              input_mark[i] := 1;
            else
              input_mark[i] := 0;
            end_if;
            // mark light
            if scene_mem[si * 200 + i] >= 0 then
              light_mark[i] := 18 + 2 * scene_mem[si * 200 + i];
            end_if;
          end_for;
        elsif mscada_page = 1 then // timetable-scenes page
          for i := 0 to 335 do
            // mark timetable
            if timetable_scene[i] = scene_selected then
              timetable_mark[i] := 1;
            else
              timetable_mark[i] := 0;
            end_if;
          end_for;
        end_if;
        scene_tout[si] := selected_scene_tout;
        scene_long_tout[si] := selected_scene_long_tout;
      else
        selected_scene_tout := 0;
        selected_scene_long_tout := 0;
      end_if;
      
      scene_selected_old := scene_selected;
      
      // light selected
      
      si := light_selected;
      if light_selected <> light_selected_old then
        selected_light_tout := light_tout[si];
        selected_light_long_tout := light_long_tout[si];
      elsif light_selected >= 0 then
        // ongoing
        light_mark[si] := 2;
        for i := 0 to 199 do
          // mark input
          if ((input_mux[i] / 10) % 10 = 1) and
             (input_mux[i] / 100 = light_selected)
          then
            input_mark[i] := 1;
          else
            input_mark[i] := 0;
          end_if;
        end_for;
        for i := 0 to 49 do
          if scene_mem[i * 200 + light_selected] = 0 then
            scene_mark[i] := 1;
          elsif scene_mem[i * 200 + light_selected] = 1 then
            scene_mark[i] := 2;
          end_if;
        end_for;
        light_tout[si] := selected_light_tout;
        light_long_tout[si] := selected_light_long_tout;
      else
        selected_light_tout := 0;
        selected_light_long_tout := 0;
      end_if;
      light_selected_old := light_selected;
      
      // timetable selected
      
      si := timetable_selected;
      if timetable_selected >= 0 then
        timetable_mark[si] := 2;
        // mark scene
        if timetable_scene[timetable_selected] >= 0 then
          scene_mark[timetable_scene[timetable_selected]] := 1;
        end_if;
      end_if;
      
      // ****************************************************************************
      // display input / scene / light state
      // ****************************************************************************
      
      // input state
      
      for i := 0 to 199 do
        if int(input[i]) <> 2 then
          input_state[i] := input_low_light[i] * 18 + 6 * (input_mux[i] % 10) + 2 * input_mark[i] + (int(input[i]) + 1);
        else
          input_state[i] := 0;
        end_if;
      end_for;
      
      // scene state
      
      for i := 0 to 49 do
        if light_selected >= 0 then
          // show the effect on the light
          if scene_mark[i] = 0 then
            scene_state[i] := ((int(scene[i]) + 1) % 3);
          else
            scene_state[i] := 24 + 3 * scene_mark[i] + ((int(scene[i]) + 1) % 3);
          end_if;
        else
          // show scene mode
          if scene_mode[i] < 6 then
            scene_state[i] := 9 * (scene_tout[i] > 0) + 3 * scene_mark[i] + ((int(scene[i]) + 1) % 3);
          else
            scene_state[i] := 18 + 3 * scene_mark[i] + ((int(scene[i]) + 1) % 3);
          end_if;
        end_if;
      end_for;
      
      // light state
      
      for i := 0 to 199 do
        // display light type
        if int(light[i]) <> 2 then
          if scene_selected >= 0 then
            // display scene effect
            light_state[i] := light_mark[i] + (int(light[i]) + 1);
          else
            // display light type
            if light_mode[i] < 6 then
              light_state[i] := 6* (light_tout[i] > 0) + 2 * light_mark[i] + (int(light[i]) + 1);
            else
              light_state[i] := 12 + 2 * light_mark[i] + (int(light[i]) + 1);
            end_if;
          end_if;
        else
          light_state[i] := 0;
        end_if;
      end_for;
      
      // timetable state
      
      for i := 0 to 335 do
        timetable_state[i] := 2 * timetable_mark[i] + (timetable_scene[i] >= 0);
      end_for;
      
      // ****************************************************************************
      // command affects selected items
      // ****************************************************************************
      
      if marked_cmd = 1 then      // inputs delete
      
        if input_selected >= 0 then
          // selected
          input_mux[input_selected] := 0;
          input_low_light[input_selected] := 0;
        else
          // all marked
          for i := 0 to 199 do
            if input_select[i] then
              input_mux[i] := 0;
              input_low_light[i] := 0;
              input_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd >= 2 and  marked_cmd <= 4 then   // inputs button - door
      
        if input_selected >= 0
        then
          if light_count = 1 then
            for i := 0 to 199 do
              if light_select[i] then
                input_mux[input_selected] := i * 100 + 10 + marked_cmd - 1;
                input_low_light[input_selected] := 0;
                light_select[i] := 0;
              end_if;
            end_for;
          elsif scene_count = 1 then
            for i := 0 to 49 do
              if scene_select[i] then
                input_mux[input_selected] := i * 100 + 20 + marked_cmd - 1;
                input_low_light[input_selected] := 0;
                scene_select[i] := 0;
              end_if;
            end_for;
          end_if;
        elsif scene_selected >= 0 then
          for i := 0 to 199 do
            if input_select[i] then
              input_mux[i] := scene_selected * 100 + 20 + marked_cmd - 1;
              input_low_light[i] := 0;
              input_select[i] := 0;
            end_if;
          end_for;
        elsif light_selected >= 0 then
          for i := 0 to 199 do
            if input_select[i] then
              input_mux[i] := light_selected * 100 + 10 + marked_cmd - 1;
              input_low_light[i] := 0;
              input_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd >= 5 and  marked_cmd <= 7 then   // inputs button - door
      
        if input_selected >= 0
        then
          if light_count = 1 then
            for i := 0 to 199 do
              if light_select[i] then
                input_mux[input_selected] := i * 100 + 10 + marked_cmd - 4;
                input_low_light[input_selected] := 1;
                light_select[i] := 0;
              end_if;
            end_for;
          elsif scene_count = 1 then
            for i := 0 to 49 do
              if scene_select[i] then
                input_mux[input_selected] := i * 100 + 20 + marked_cmd - 4;
                input_low_light[input_selected] := 1;
                scene_select[i] := 0;
              end_if;
            end_for;
          end_if;
        elsif scene_selected >= 0 then
          for i := 0 to 199 do
            if input_select[i] then
              input_mux[i] := scene_selected * 100 + 20 + marked_cmd - 4;
              input_low_light[i] := 1;
              input_select[i] := 0;
            end_if;
          end_for;
        elsif light_selected >= 0 then
          for i := 0 to 199 do
            if input_select[i] then
              input_mux[i] := light_selected * 100 + 10 + marked_cmd - 4;
              input_low_light[i] := 1;
              input_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 8 then   // scene delete
      
        if scene_selected >= 0 then
          for i := 0 to 199 do
            scene_mem[scene_selected * 200 + i] := -1;
          end_for;
        elsif light_selected >= 0 then
          for i := 0 to 49 do
            if scene_select[i] then
              scene_mem[i * 200 + light_selected] := -1;
              scene_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 9 then   // scene on
      
        if scene_selected >= 0
        then
          scene_cmd := 100 + scene_selected;
        elsif light_selected >= 0 then
          for i := 0 to 49 do
            if scene_select[i] then
              scene_mem[i * 200 + light_selected] := 1;
              scene_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 10 then   // scene off
      
        if scene_selected >= 0
        then
          scene_cmd := 50 + scene_selected;
        elsif light_selected >= 0 then
          for i := 0 to 49 do
            if scene_select[i] then
              scene_mem[i * 200 + light_selected] := 0;
              scene_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 11 then   // light delete
      
        if scene_selected >= 0 then
          for i := 0 to 199 do
            if light_select[i] then
              scene_mem[scene_selected * 200 + i] := -1;
              light_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 12 then   // light on
      
        if light_selected >= 0 then
          light[light_selected] := 1;
        elsif scene_selected >= 0 then
          for i := 0 to 199 do
            if light_select[i] then
              scene_mem[scene_selected * 200 + i] := 1;
              light_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 13 then   // light off
      
        if light_selected >= 0 then
          light[light_selected] := 0;
        elsif scene_selected >= 0 then
          for i := 0 to 199 do
            if light_select[i] then
              scene_mem[scene_selected * 200 + i] := 0;
              light_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      elsif marked_cmd = 20 then   // timetable delete
      
        if timetable_selected >= -1 then
          timetable_scene[timetable_selected] := -1;
        end_if;
      
        for i := 0 to 335 do
          if timetable_select[i] then
            timetable_scene[i] := -1;
            timetable_select[i] := 0;
          end_if;
        end_for;
      
      elsif marked_cmd = 21 then   // timetable set
      
        if timetable_selected >= -1 and
           scene_count = 1
        then
          for i := 0 to 49 do
            if scene_select[i] then
              timetable_scene[timetable_selected] := i;
              scene_select[i] := 0;
            end_if;
          end_for;
        elsif scene_selected >= 0 then
          for i := 0 to 335 do
            if timetable_select[i] then
              timetable_scene[i] := scene_selected;
              timetable_select[i] := 0;
            end_if;
          end_for;
        end_if;
      
      end_if;
      marked_cmd := 0;
      
      // ****************************************************************************
      // edit screen mask
      // ****************************************************************************
      
      mask_input := 0;
      if input_selected >= 0
      then
        if input_mux[input_selected] > 0 then
          mask_input := 1;
        end_if;
        if select_count = 1 then
          if scene_count = 1 then
            mask_input := 2;
          end_if;
          if light_count = 1 then
            mask_input := 3;
          end_if;
        end_if;
      end_if;
      if scene_selected >= 0 and input_count > 0 then
        mask_input := 2;
      end_if;
      if light_selected >= 0 and input_count > 0 then
        mask_input := 3;
      end_if;
      
      mask_scene := 0;
      if (scene_selected >= 0 and scene[scene_selected] <> 2) or
         (light_selected >= 0 and scene_count > 0)
      then
        mask_scene := 1;
      end_if;
      
      mask_light := 0;
      if light_selected >= 0 then
        mask_light := 1;
      end_if;
      if scene_selected >= 0 and
         light_count > 0
      then
        mask_light := 2;
      end_if;
      
      mask_timetable := 0;
      if (timetable_selected >= 0 and timetable_scene[timetable_selected] >= 0) or
         timetable_count > 0
      then
        mask_timetable := 1;
      end_if;
      if (timetable_selected >= 0 and scene_count = 1) or
         timetable_count > 0
      then
        mask_timetable := 2;
      end_if;
      
      
      // ****************************************************************************
      // instructions text index
      // ****************************************************************************
      
      txt_idx := 0;
      
      if input_selected >= 0 then
        txt_idx := 1;
        if select_count = 1 then
          txt_idx := 2;
        elsif select_count > 1 then
          txt_idx := 3;
        end_if;
      end_if;
      
      if scene_selected >= 0 then
        if mscada_page = 0 then
          txt_idx := 4;
          if input_count > 0 then
            txt_idx := 5;
          end_if;
          if light_count > 0 then
            txt_idx := 6;
          end_if;
        elsif mscada_page = 1 then
          txt_idx := 13;
          if timetable_count > 0 then
            txt_idx := 14;
          end_if;
        end_if;
      end_if;
      
      if light_selected >= 0 then
        txt_idx := 7;
        if input_count > 0 then
          txt_idx := 8;
        end_if;
        if scene_count > 0 then
          txt_idx := 9;
        end_if;
      end_if;
      
      if timetable_selected >= 0 then
        txt_idx := 10;
        if scene_count = 1 then
          txt_idx := 11;
        elsif scene_count > 1 then
          txt_idx := 12;
        end_if;
      end_if;
      
      
    end;
  begin
    
    f_input_mux();
    
    f_timetable();
    
    f_low_light();
    
    f_light();
    
    f_scene();
    
    f_configure();
    
  end;
begin
  f_system();
  
  if !ee_read_req then
  
    f_parameters();
  
    f_io_mux();
  
    f_algorithms();
  
  end_if;
end;
#CODE_END

#DESCRIPTION_BEGIN
#DESCRIPTION_END

##PROGRAM_END_1

